/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.entity.hostile;

import dev.xkmc.glimmeringtales.content.entity.hostile.MobCastingConfig;
import dev.xkmc.glimmeringtales.content.entity.hostile.MobSpellData;
import dev.xkmc.glimmeringtales.content.entity.hostile.MobSpellHelper;
import dev.xkmc.glimmeringtales.content.entity.hostile.StrafingRangedAttackGoal;
import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class SpellCastGoal
extends StrafingRangedAttackGoal
implements MobSpellHelper {
    private int useTick = 0;

    public SpellCastGoal(Mob mob, MobCastingConfig config) {
        super(mob, config);
    }

    @Override
    protected double getAttackRangeSqr(LivingEntity target) {
        MobSpellData spell = this.getSpell();
        if (spell == null) {
            return 256.0;
        }
        double range = spell.mob().idealRange();
        AttributeInstance ins = this.mob.getAttribute(Attributes.FOLLOW_RANGE);
        if (ins != null) {
            range = Math.min(range, ins.getValue());
        }
        return range * range;
    }

    @Override
    public void start() {
        super.start();
        this.useTick = 0;
    }

    @Override
    public void stop() {
        MobSpellData spell;
        if (this.useTick > 0 && (spell = this.getSpell()) != null) {
            this.nextAttackTimestamp = this.mob.level().getGameTime() + (long)spell.getCooldown(this.useTick);
        }
        this.useTick = 0;
        if (this.mob.isUsingItem()) {
            this.mob.stopUsingItem();
        }
        super.stop();
    }

    @Override
    public void setUseTick(int tick) {
        this.useTick = tick;
    }

    @Override
    public void setImmobile(int tick) {
        this.immobileTime = tick;
    }

    @Override
    protected int attack(LivingEntity target, boolean withinRange) {
        return this.attack(this.mob, target, this.useTick, withinRange);
    }

    @Override
    protected boolean canCastSpell() {
        MobSpellData spell = this.getSpell();
        return spell != null;
    }

    @Override
    @Nullable
    public MobSpellData getSpell() {
        return MobSpellHelper.getSpell(this.mob, InteractionHand.MAIN_HAND);
    }
}

