/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.entity.hostile;

import dev.xkmc.glimmeringtales.content.core.spell.NatureSpell;
import dev.xkmc.glimmeringtales.content.core.spell.SpellInfo;
import dev.xkmc.glimmeringtales.content.entity.hostile.MobSpellData;
import dev.xkmc.glimmeringtales.content.item.rune.BaseRuneItem;
import dev.xkmc.glimmeringtales.content.item.wand.ISpellHolder;
import dev.xkmc.glimmeringtales.content.item.wand.RuneWandItem;
import dev.xkmc.glimmeringtales.content.item.wand.SpellCastContext;
import dev.xkmc.glimmeringtales.init.reg.GTItems;
import dev.xkmc.glimmeringtales.init.reg.GTRegistries;
import dev.xkmc.l2magic.content.engine.spell.SpellAction;
import dev.xkmc.l2magic.content.engine.spell.SpellCastType;
import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface MobSpellHelper {
    @Nullable
    public MobSpellData getSpell();

    public void setUseTick(int var1);

    public void setImmobile(int var1);

    default public int modifyDelay(int delay) {
        return delay;
    }

    default public int attack(Mob mob, LivingEntity target, int useTick, boolean withinRange) {
        int cost;
        MobSpellData mobData = this.getSpell();
        if (mobData == null) {
            return 20;
        }
        if (!withinRange) {
            if (useTick <= 0) {
                return 0;
            }
            mob.stopUsingItem();
            this.setUseTick(0);
            return mobData.getCooldown(useTick);
        }
        SpellAction action = (SpellAction)mobData.spell().spell().value();
        int delay = this.modifyDelay(mobData.mob().standardDelay());
        SpellCastContext ctx = SpellCastContext.of(mob.level(), (LivingEntity)mob, delay, mobData.wand());
        if (action.castType() == SpellCastType.INSTANT) {
            mobData.holder().cast(ctx, 0, false);
            cost = 1;
            this.setImmobile(delay);
        } else {
            if (useTick == 0) {
                mob.startUsingItem(InteractionHand.MAIN_HAND);
            }
            if (useTick < mobData.mob().maxUseTick() + delay) {
                mobData.holder().cast(ctx, useTick, action.castType() == SpellCastType.CHARGE);
                this.setUseTick(useTick + 1);
                return 0;
            }
            if (action.castType() == SpellCastType.CHARGE) {
                mobData.holder().cast(ctx, useTick, false);
            }
            cost = useTick - delay;
            mob.stopUsingItem();
            this.setUseTick(0);
        }
        return mobData.getCooldown(cost);
    }

    @Nullable
    public static MobSpellData getSpell(Mob mob, InteractionHand hand) {
        return MobSpellHelper.getSpell((LivingEntity)mob, mob.getItemInHand(hand));
    }

    @Nullable
    public static MobSpellData getSpell(LivingEntity mob, ItemStack wand) {
        if (!wand.is(GTItems.WAND)) {
            return null;
        }
        ItemStack core = RuneWandItem.getCore(wand);
        Item item = core.getItem();
        if (item instanceof BaseRuneItem) {
            NatureSpell ns;
            BaseRuneItem item2 = (BaseRuneItem)item;
            ISpellHolder holder = item2.getSpell(core, mob.level());
            SpellInfo info = item2.getSpellInfo(mob.level().registryAccess());
            if (holder != null && info.spell() != null && (ns = (NatureSpell)info.spell().value()).mob() != null) {
                AttributeInstance ins = mob.getAttribute(GTRegistries.MANA_REGEN);
                double regen = ins == null ? ((Attribute)GTRegistries.MANA_REGEN.get()).getDefaultValue() : ins.getValue();
                return new MobSpellData(wand, ns, holder, ns.mob(), info.getCost(mob, wand), regen);
            }
        }
        return null;
    }
}

