/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.engine.render;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.xkmc.l2magic.content.entity.core.LMProjectile;
import dev.xkmc.l2magic.content.entity.renderer.LMProjectileRenderer;
import dev.xkmc.l2magic.content.entity.renderer.ProjectileRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.model.data.ModelData;

public record FakeBlockRenderer(BlockState state, float scale) implements ProjectileRenderer
{
    public ResourceLocation getTexture() {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    public void render(LMProjectile entity, LMProjectileRenderer<?> r, float v, PoseStack pose, MultiBufferSource buffer, int packedLight) {
        if (this.state.getRenderShape() != RenderShape.MODEL) {
            return;
        }
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        Level level = entity.level();
        pose.pushPose();
        BlockPos pos = BlockPos.containing((double)entity.getX(), (double)entity.getBoundingBox().maxY, (double)entity.getZ());
        pose.scale(this.scale, this.scale, this.scale);
        pose.translate(-0.5, -0.5, -0.5);
        BakedModel model = dispatcher.getBlockModel(this.state);
        int seed = entity.getId();
        for (RenderType rt : model.getRenderTypes(this.state, RandomSource.create((long)seed), ModelData.EMPTY)) {
            dispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)level, dispatcher.getBlockModel(this.state), this.state, pos, pose, buffer.getBuffer(RenderTypeHelper.getMovingBlockRenderType((RenderType)rt)), false, RandomSource.create(), (long)seed, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, rt);
        }
        pose.popPose();
    }
}

