/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.engine.instance;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xkmc.glimmeringtales.init.reg.GTEngine;
import dev.xkmc.l2magic.content.engine.block.IBlockProcessor;
import dev.xkmc.l2magic.content.engine.context.EngineContext;
import dev.xkmc.l2magic.content.engine.core.EngineType;
import dev.xkmc.l2magic.content.engine.variable.IntVariable;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public record RemoveLiquidInstance(IntVariable depth, IntVariable limit, FluidType fluid) implements IBlockProcessor<RemoveLiquidInstance>
{
    public static final MapCodec<RemoveLiquidInstance> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)IntVariable.codec((String)"depth", RemoveLiquidInstance::depth), (App)IntVariable.codec((String)"limit", RemoveLiquidInstance::limit), (App)NeoForgeRegistries.FLUID_TYPES.byNameCodec().fieldOf("fluid").forGetter(RemoveLiquidInstance::fluid)).apply((Applicative)i, RemoveLiquidInstance::new));

    public EngineType<RemoveLiquidInstance> type() {
        return (EngineType)GTEngine.SPONGE.get();
    }

    public void execute(EngineContext ctx) {
        RemoveLiquidInstance.removeWaterBreadthFirstSearch(ctx.user().level(), BlockPos.containing((Position)ctx.loc().pos()), this.depth.eval(ctx), this.limit.eval(ctx), e -> e.getType().getFluidType() == this.fluid);
    }

    private static boolean removeWaterBreadthFirstSearch(Level level, BlockPos pos, int depth, int limit, Predicate<FluidState> pred) {
        return BlockPos.breadthFirstTraversal((BlockPos)pos, (int)depth, (int)limit, (p, c) -> {
            for (Direction dir : Direction.values()) {
                c.accept(p.relative(dir));
            }
        }, p -> {
            BucketPickup bucket;
            BlockState state = level.getBlockState(p);
            FluidState fluid = level.getFluidState(p);
            if (!pred.test(fluid)) {
                return false;
            }
            Block patt0$temp = state.getBlock();
            if (patt0$temp instanceof BucketPickup && !(bucket = (BucketPickup)patt0$temp).pickupBlock(null, (LevelAccessor)level, p, state).isEmpty()) {
                return true;
            }
            if (state.getBlock() instanceof LiquidBlock) {
                level.setBlock(p, Blocks.AIR.defaultBlockState(), 3);
            } else {
                BlockEntity blockentity = state.hasBlockEntity() ? level.getBlockEntity(p) : null;
                Block.dropResources((BlockState)state, (LevelAccessor)level, (BlockPos)p, (BlockEntity)blockentity);
                level.setBlock(p, Blocks.AIR.defaultBlockState(), 3);
            }
            return true;
        }) > 1;
    }
}

