/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.engine.instance;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xkmc.glimmeringtales.content.core.spell.BlockReplace;
import dev.xkmc.glimmeringtales.init.reg.GTEngine;
import dev.xkmc.glimmeringtales.init.reg.GTRegistries;
import dev.xkmc.l2magic.content.engine.block.BlockUtils;
import dev.xkmc.l2magic.content.engine.block.IBlockProcessor;
import dev.xkmc.l2magic.content.engine.context.EngineContext;
import dev.xkmc.l2magic.content.engine.core.EngineType;
import dev.xkmc.l2magic.content.engine.variable.IntVariable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public record MeltBlockInstance(IntVariable tick) implements IBlockProcessor<MeltBlockInstance>
{
    public static final MapCodec<MeltBlockInstance> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)IntVariable.codec((String)"tick", e -> e.tick)).apply((Applicative)i, MeltBlockInstance::new));

    public EngineType<MeltBlockInstance> type() {
        return (EngineType)GTEngine.MELT_BLOCK.get();
    }

    public void execute(EngineContext ctx) {
        if (!(ctx.user().level() instanceof ServerLevel)) {
            return;
        }
        Level level = ctx.user().level();
        BlockPos pos = BlockPos.containing((Position)ctx.loc().pos());
        BlockState state = level.getBlockState(pos);
        BlockReplace e = (BlockReplace)GTRegistries.MELT.get(level.registryAccess(), state.getBlockHolder());
        if (e == null) {
            return;
        }
        BlockState next = e.state(state);
        BlockUtils.set((EngineContext)ctx, (BlockState)next);
        level.scheduleTick(pos, next.getBlock(), this.tick.eval(ctx));
    }
}

