/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.engine.instance;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xkmc.glimmeringtales.content.entity.misc.GTLightningBolt;
import dev.xkmc.glimmeringtales.init.data.GTDamageTypeGen;
import dev.xkmc.glimmeringtales.init.reg.GTEngine;
import dev.xkmc.glimmeringtales.init.reg.GTEntities;
import dev.xkmc.l2damagetracker.contents.attack.AttackEventHandler;
import dev.xkmc.l2magic.content.engine.block.IBlockProcessor;
import dev.xkmc.l2magic.content.engine.context.EngineContext;
import dev.xkmc.l2magic.content.engine.core.EngineType;
import dev.xkmc.l2magic.content.engine.selector.SelectionType;
import dev.xkmc.l2magic.content.engine.variable.DoubleVariable;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public record LightningInstance(DoubleVariable damage) implements IBlockProcessor<LightningInstance>
{
    public static final MapCodec<LightningInstance> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)DoubleVariable.codec((String)"damage", e -> e.damage)).apply((Applicative)i, LightningInstance::new));

    @Nullable
    public static DamageSource source(DamageSource source, LightningBolt bolt, Entity target) {
        Level level;
        LivingEntity sp;
        block7: {
            block6: {
                ServerPlayer e;
                if (bolt instanceof GTLightningBolt) {
                    GTLightningBolt gt = (GTLightningBolt)bolt;
                    v0 = gt.getOwner();
                } else {
                    v0 = e = bolt.getCause();
                }
                if (!(e instanceof LivingEntity)) break block6;
                sp = (LivingEntity)e;
                level = bolt.level();
                if (level instanceof ServerLevel) break block7;
            }
            return source;
        }
        ServerLevel sl = (ServerLevel)level;
        if (!SelectionType.ENEMY_NO_FAMILY.test(target, sp)) {
            return null;
        }
        return AttackEventHandler.createSource((ServerLevel)sl, (LivingEntity)sp, GTDamageTypeGen.THUNDER, (Entity)bolt, null);
    }

    public EngineType<LightningInstance> type() {
        return (EngineType)GTEngine.THUNDER.get();
    }

    public void execute(EngineContext ctx) {
        BlockPos pos;
        if (!(ctx.user().level() instanceof ServerLevel)) {
            return;
        }
        Level level = ctx.user().level();
        BlockState state = level.getBlockState(pos = BlockPos.containing((Position)ctx.loc().pos()));
        if (state.isCollisionShapeFullBlock((BlockGetter)level, pos)) {
            pos = pos.above();
        }
        GTLightningBolt bolt = new GTLightningBolt((EntityType<? extends GTLightningBolt>)((EntityType)GTEntities.LIGHTNING.get()), level);
        bolt.addTag("l2library:safe_lightning");
        bolt.addTag("glimmeringtales");
        bolt.moveTo(Vec3.atBottomCenterOf((Vec3i)pos));
        bolt.setOwner((Entity)ctx.user().user());
        bolt.setDamage((float)this.damage.eval(ctx));
        level.addFreshEntity((Entity)bolt);
    }
}

