/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.engine.instance;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xkmc.glimmeringtales.content.entity.misc.GTFallingBlockEntity;
import dev.xkmc.glimmeringtales.init.reg.GTEngine;
import dev.xkmc.l2magic.content.engine.block.IBlockProcessor;
import dev.xkmc.l2magic.content.engine.context.EngineContext;
import dev.xkmc.l2magic.content.engine.core.EngineType;
import dev.xkmc.l2magic.content.engine.variable.DoubleVariable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public record GTKnockBlock(DoubleVariable speed, DoubleVariable damagePerBlock, DoubleVariable maxDamage) implements IBlockProcessor<GTKnockBlock>
{
    public static final MapCodec<GTKnockBlock> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)DoubleVariable.codec((String)"speed", GTKnockBlock::speed), (App)DoubleVariable.optionalCodec((String)"damagePerBlock", GTKnockBlock::damagePerBlock), (App)DoubleVariable.optionalCodec((String)"maxDamage", GTKnockBlock::maxDamage)).apply((Applicative)i, (a, b, c) -> new GTKnockBlock((DoubleVariable)a, b.orElse(DoubleVariable.ZERO), c.orElse(b.orElse(DoubleVariable.ZERO)))));

    public EngineType<GTKnockBlock> type() {
        return (EngineType)GTEngine.KNOCK.get();
    }

    public void execute(EngineContext ctx) {
        Level level = ctx.user().level();
        if (level.isClientSide()) {
            return;
        }
        BlockPos pos = BlockPos.containing((Position)ctx.loc().pos());
        if (level.getBlockEntity(pos) != null) {
            return;
        }
        BlockState state = level.getBlockState(pos);
        if (state.canBeReplaced()) {
            return;
        }
        level.setBlockAndUpdate(pos, state.getFluidState().createLegacyBlock());
        GTFallingBlockEntity e = GTKnockBlock.fall(level, pos, state);
        e.setDeltaMovement(0.0, this.speed.eval(ctx), 0.0);
        e.setOwner((Entity)ctx.user().user());
        e.setHurtsEntities((float)this.damagePerBlock().eval(ctx), (int)this.maxDamage().eval(ctx));
        level.addFreshEntity((Entity)e);
    }

    public static GTFallingBlockEntity fall(Level level, BlockPos pos, BlockState state) {
        BooleanProperty w = BlockStateProperties.WATERLOGGED;
        BlockState blockState = state = state.hasProperty((Property)w) ? (BlockState)state.setValue((Property)w, (Comparable)Boolean.valueOf(false)) : state;
        if (state.is(Blocks.GRASS_BLOCK) && state.hasProperty((Property)BlockStateProperties.SNOWY)) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.SNOWY, (Comparable)Boolean.valueOf(false));
        }
        if (state.is(Blocks.DIRT_PATH) || state.is(Blocks.FARMLAND)) {
            state = Blocks.DIRT.defaultBlockState();
        }
        return new GTFallingBlockEntity(level, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, state);
    }
}

