/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.core.spell;

import dev.xkmc.glimmeringtales.content.core.description.SpellTooltip;
import dev.xkmc.glimmeringtales.content.core.spell.BlockSpell;
import dev.xkmc.glimmeringtales.content.core.spell.DefaultAffinity;
import dev.xkmc.glimmeringtales.content.core.spell.ElementAffinity;
import dev.xkmc.glimmeringtales.content.core.spell.IAffinityProvider;
import dev.xkmc.glimmeringtales.content.core.spell.NatureSpell;
import dev.xkmc.glimmeringtales.content.core.spell.RuneBlock;
import dev.xkmc.glimmeringtales.content.core.spell.SpellCost;
import dev.xkmc.glimmeringtales.content.research.core.HexGraphData;
import dev.xkmc.glimmeringtales.content.research.core.PlayerResearch;
import dev.xkmc.glimmeringtales.content.research.core.SpellResearch;
import dev.xkmc.glimmeringtales.init.data.GTLang;
import dev.xkmc.glimmeringtales.init.data.GTTagGen;
import dev.xkmc.l2core.util.Proxy;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public record SpellInfo(@Nullable Holder<NatureSpell> spell, IAffinityProvider affinity, boolean advanced, boolean consume) {
    public static final SpellInfo EMPTY = new SpellInfo(null, DefaultAffinity.INS, false, false);

    public static SpellInfo ofSpell(@Nullable Holder<NatureSpell> spell) {
        if (spell == null) {
            return EMPTY;
        }
        return new SpellInfo(spell, DefaultAffinity.INS, true, false);
    }

    public static SpellInfo ofRune(@Nullable RuneBlock rune) {
        if (rune == null) {
            return EMPTY;
        }
        return new SpellInfo(rune.spell(), DefaultAffinity.INS, false, false);
    }

    public static SpellInfo ofBlock(BlockSpell block, ElementAffinity aff) {
        return new SpellInfo(block.spell(), aff, false, block.breakBlock());
    }

    public SpellCost getCost(LivingEntity player, ItemStack wand) {
        if (this.spell == null) {
            return SpellCost.ZERO;
        }
        NatureSpell ns = (NatureSpell)this.spell.value();
        return ns.manaCost(player, this.affinity().getFinalAffinity(ns.elem(), player, wand));
    }

    public List<Component> getCastTooltip(Player player, ItemStack wand, ItemStack core) {
        if (this.spell == null) {
            return List.of();
        }
        NatureSpell ns = (NatureSpell)this.spell.value();
        ResourceKey id = (ResourceKey)this.spell.unwrapKey().orElseThrow();
        ArrayList<Component> list = new ArrayList<Component>();
        SpellCost cost = this.getCost((LivingEntity)player, wand);
        ns.addDescription(list, cost, this.advanced());
        SpellTooltip.get(player.level(), ns).brief((ResourceKey<NatureSpell>)id, list);
        if (this.spell.is(GTTagGen.GROUNDED)) {
            list.add((Component)GTLang.DESC_GROUND.get(new Object[0]).withStyle(ChatFormatting.RED));
        }
        cost.addCostInfo(list, player);
        if (this.consume) {
            list.add((Component)GTLang.OVERLAY_DESTROY.get(new Object[0]).withStyle(ChatFormatting.RED));
        }
        return list;
    }

    public void runeItemDesc(Level level, List<Component> list, boolean shift) {
        if (this.spell == null) {
            return;
        }
        NatureSpell ns = (NatureSpell)this.spell.value();
        ResourceKey id = (ResourceKey)this.spell.unwrapKey().orElseThrow();
        Player pl = Proxy.getPlayer();
        ns.addDescription(list, ns.manaCost((LivingEntity)(shift ? null : pl), 1.0), !shift && this.advanced());
        list.add(SpellTooltip.get(level, ns).format((ResourceKey<NatureSpell>)id));
        if (!shift) {
            if (this.spell.is(GTTagGen.GROUNDED)) {
                list.add((Component)GTLang.DESC_GROUND.get(new Object[0]).withStyle(ChatFormatting.RED));
            }
            if (ns.mob() != null) {
                list.add((Component)GTLang.TOOLTIP_MOB_USE.get(new Object[0]).withStyle(ChatFormatting.RED));
            }
        }
        if (ns.graph() == null) {
            return;
        }
        if (pl == null) {
            return;
        }
        SpellResearch research = PlayerResearch.of(pl).get(((ResourceKey)ns.graph().unwrapKey().orElseThrow()).location());
        if (research == null) {
            return;
        }
        if (!shift) {
            list.add((Component)GTLang.DESC_SHIFT.get(new Object[0]).withStyle(ChatFormatting.GRAY));
        } else {
            research.getFullDesc(list, ((HexGraphData)ns.graph().value()).bonuses());
        }
    }
}

