/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.core.spell;

import dev.xkmc.glimmeringtales.content.capability.PlayerManaCapability;
import dev.xkmc.glimmeringtales.init.data.GTLang;
import dev.xkmc.glimmeringtales.init.reg.GTRegistries;
import dev.xkmc.l2core.capability.player.PlayerCapabilityHolder;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.attachment.IAttachmentHolder;

public record SpellCost(double focus, double mana, boolean researchable) {
    public static final SpellCost ZERO = new SpellCost(0.0, 0.0, false);

    public MutableComponent manaText(double factor) {
        return Component.literal((String)("" + Math.round(this.mana() * factor)));
    }

    public MutableComponent focusText(double factor) {
        double val = this.focus() * factor;
        int num = (int)Math.round(val);
        if (val < 5.0 && Math.abs(val - (double)num) > 0.1) {
            return Component.literal((String)("" + (double)Math.round(val * 10.0) * 0.1));
        }
        return Component.literal((String)("" + num));
    }

    public void addCostInfo(List<Component> list, Player player) {
        PlayerManaCapability mana = ((PlayerCapabilityHolder)GTRegistries.MANA.type()).getExisting((IAttachmentHolder)player).orElse(null);
        if (mana == null) {
            return;
        }
        list.add(this.addLine(player, (Holder<Attribute>)GTRegistries.MAX_MANA, GTLang.OVERLAY_MANA, this.mana(), mana.getMana()));
        list.add(this.addLine(player, (Holder<Attribute>)GTRegistries.MAX_FOCUS, GTLang.OVERLAY_FOCUS, this.focus(), mana.getFocus()));
    }

    private Component addLine(Player player, Holder<Attribute> attr, GTLang lang, double cost, double val) {
        double max = player.getAttributeValue(attr);
        MutableComponent cmval = Component.literal((String)("" + Math.round(val))).withStyle(val < cost ? ChatFormatting.RED : (val < max ? ChatFormatting.GREEN : ChatFormatting.AQUA));
        MutableComponent cmmax = Component.literal((String)("" + Math.round(max))).withStyle(ChatFormatting.AQUA);
        return lang.get(cmval, cmmax).withStyle(ChatFormatting.LIGHT_PURPLE);
    }
}

