/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.core.spell;

import dev.xkmc.glimmeringtales.content.capability.PlayerManaCapability;
import dev.xkmc.glimmeringtales.content.core.description.SpellTooltipData;
import dev.xkmc.glimmeringtales.content.core.spell.ResearchBonus;
import dev.xkmc.glimmeringtales.content.core.spell.SpellCost;
import dev.xkmc.glimmeringtales.content.core.spell.SpellElement;
import dev.xkmc.glimmeringtales.content.entity.hostile.MobCastingData;
import dev.xkmc.glimmeringtales.content.research.core.HexGraphData;
import dev.xkmc.glimmeringtales.content.research.core.PlayerResearch;
import dev.xkmc.glimmeringtales.content.research.core.ResearchState;
import dev.xkmc.glimmeringtales.content.research.core.SpellResearch;
import dev.xkmc.glimmeringtales.init.data.GTLang;
import dev.xkmc.glimmeringtales.init.reg.GTRegistries;
import dev.xkmc.l2core.capability.player.PlayerCapabilityHolder;
import dev.xkmc.l2magic.content.engine.spell.SpellAction;
import dev.xkmc.l2magic.content.engine.spell.SpellCastType;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.attachment.IAttachmentHolder;

public record NatureSpell(Holder<SpellAction> spell, SpellElement elem, int focus, int cost, int maxConsumeTick, SpellTooltipData tooltip, @Nullable MobCastingData mob, @Nullable Holder<HexGraphData> graph) {
    private static final int MIN_MANA_COST = 1;
    private static final int CAST_COOLDOWN = 10;
    private static final int BREAK_COOLDOWN = 20;
    private static final double MIN_AFFINITY = 0.2;

    public boolean consumeMana(LivingEntity user, ItemStack stack, double affinity, int useTick, boolean charging, boolean simulate) {
        SpellCost consume = this.manaCost(user, affinity);
        SpellCastType cast = ((SpellAction)this.spell().value()).castType();
        if (this.maxConsumeTick > 0) {
            if (cast == SpellCastType.CONTINUOUS && useTick > this.maxConsumeTick) {
                consume = SpellCost.ZERO;
            }
            if (!(cast != SpellCastType.CHARGE || charging && useTick <= this.maxConsumeTick)) {
                consume = SpellCost.ZERO;
            }
        }
        if (user instanceof Player) {
            Player player = (Player)user;
            PlayerManaCapability mana = (PlayerManaCapability)((PlayerCapabilityHolder)GTRegistries.MANA.type()).getOrCreate((IAttachmentHolder)player);
            if (simulate) {
                return mana.getMana() >= (double)this.cost && mana.getFocus() >= (double)this.focus;
            }
            if (!mana.consume(player, consume)) {
                if (!user.level().isClientSide() && (((SpellAction)this.spell.value()).castType() == SpellCastType.CONTINUOUS || ((SpellAction)this.spell.value()).castType() == SpellCastType.CHARGE && charging)) {
                    player.getCooldowns().addCooldown(stack.getItem(), 20);
                }
                return false;
            }
            if (!user.level().isClientSide() && (((SpellAction)this.spell.value()).castType() == SpellCastType.INSTANT || ((SpellAction)this.spell.value()).castType() == SpellCastType.CHARGE && !charging)) {
                player.getCooldowns().addCooldown(stack.getItem(), 10);
            }
        }
        return true;
    }

    private MutableComponent lang() {
        return Component.translatable((String)SpellAction.lang((ResourceLocation)((ResourceKey)this.spell().unwrapKey().orElseThrow()).location()));
    }

    public SpellCost manaCost(@Nullable LivingEntity le, double affinity) {
        if (affinity < 0.2) {
            affinity = 0.2;
        }
        double mana = (double)this.cost / affinity;
        double focus = this.focus();
        if (le instanceof OwnableEntity) {
            OwnableEntity own = (OwnableEntity)le;
            le = own.getOwner();
        }
        boolean researchable = false;
        if (le instanceof Player) {
            Player player = (Player)le;
            if (this.graph != null) {
                researchable = true;
                HexGraphData g = (HexGraphData)this.graph.value();
                SpellResearch research = PlayerResearch.of(player).get(((ResourceKey)this.graph.unwrapKey().orElseThrow()).location());
                if (research != null && research.getState() == ResearchState.COMPLETED) {
                    int cost = research.getCost();
                    for (ResearchBonus ent : g.bonuses()) {
                        if (cost > ent.cost()) continue;
                        mana = ent.modifyMana(mana);
                        focus = ent.modifyFocus(focus);
                    }
                }
            }
        }
        return new SpellCost(focus, Math.max(1.0, mana), researchable);
    }

    void addDescription(List<Component> list, SpellCost consume, boolean advanced) {
        list.add((Component)GTLang.TOOLTIP_SPELL.get(this.lang().withStyle(ChatFormatting.GOLD), this.elem.coloredDesc()).withStyle(ChatFormatting.GRAY));
        if (advanced) {
            list.add((Component)((SpellAction)this.spell().value()).castType().desc());
            list.add((Component)((SpellAction)this.spell().value()).triggerType().desc());
        }
        list.add(this.addLine(GTLang.TOOLTIP_COST, consume::manaText));
        list.add(this.addLine(GTLang.TOOLTIP_FOCUS, consume::focusText));
    }

    private Component addLine(GTLang lang, Function<Integer, MutableComponent> func) {
        MutableComponent val = func.apply(1).withStyle(ChatFormatting.BLUE);
        if (((SpellAction)this.spell().value()).castType() != SpellCastType.INSTANT) {
            if (this.maxConsumeTick <= 0) {
                val = GTLang.TOOLTIP_COST_CONT.get(val).withStyle(ChatFormatting.GRAY);
            } else {
                MutableComponent max = func.apply(this.maxConsumeTick).withStyle(ChatFormatting.BLUE);
                val = GTLang.TOOLTIP_COST_CAPPED.get(val, max).withStyle(ChatFormatting.GRAY);
            }
        }
        return lang.get(val).withStyle(ChatFormatting.YELLOW);
    }
}

