/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.core.searcher;

import dev.xkmc.glimmeringtales.content.item.tool.IBlockSearcher;
import dev.xkmc.l2core.base.effects.api.IDelayedRender;
import dev.xkmc.l2core.base.effects.api.SimpleIcon;
import dev.xkmc.l2core.events.ClientEffectRenderEvents;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BlockSearcher {
    private final IBlockSearcher source;
    private final Map<BlockPos, Entry> map = new LinkedHashMap<BlockPos, Entry>();
    private final Block target;
    private final TagKey<Block> hint;
    private final int minY;
    private final int maxY;
    private final int bonusChance;
    private final int bonusTrial;
    private final int br;
    private final IntSupplier radius;
    private final IntSupplier trial;

    public static void iterate(Player player, Consumer<BlockSearcher> cons) {
        HashSet<BlockSearcher> set = new HashSet<BlockSearcher>();
        BlockSearcher.iterate(set, player.getMainHandItem(), cons);
        BlockSearcher.iterate(set, player.getOffhandItem(), cons);
    }

    private static void iterate(Set<BlockSearcher> set, ItemStack stack, Consumer<BlockSearcher> cons) {
        Item item = stack.getItem();
        if (item instanceof IBlockSearcher) {
            IBlockSearcher item2 = (IBlockSearcher)item;
            BlockSearcher s = item2.getSearcher();
            if (set.contains(s)) {
                return;
            }
            set.add(s);
            cons.accept(s);
        }
    }

    public BlockSearcher(IBlockSearcher source, Block target, TagKey<Block> hint, int minY, int maxY, IntSupplier radius, IntSupplier trial, int bonusChance, int bonusTrial, int br) {
        this.source = source;
        this.target = target;
        this.hint = hint;
        this.minY = minY;
        this.maxY = maxY;
        this.radius = radius;
        this.trial = trial;
        this.bonusChance = bonusChance;
        this.bonusTrial = bonusTrial;
        this.br = br;
    }

    public void tick(Player player) {
        Level level = player.level();
        BlockPos pos = player.blockPosition();
        RandomSource rand = RandomSource.create();
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        int bonus = this.bonusChance;
        int trial = this.trial.getAsInt();
        int radius = this.radius.getAsInt();
        for (int i = 0; i < trial; ++i) {
            this.rand(pos, p, radius, rand);
            BlockState state = level.getBlockState((BlockPos)p);
            if (state.is(this.target)) {
                new Entry(level, p.immutable()).put();
                continue;
            }
            if (!state.is(this.hint) || bonus <= 0) continue;
            --bonus;
            BlockPos ip = p.immutable();
            this.search(level, ip, p, this.bonusTrial, this.br, rand);
        }
        this.search(level, pos, p, trial / 4, 16, rand);
        if (Minecraft.getInstance().isPaused()) {
            return;
        }
        this.map.entrySet().removeIf(ent -> ((Entry)ent.getValue()).shouldRemove(player, level));
    }

    private void search(Level level, BlockPos ip, BlockPos.MutableBlockPos p, int trial, int br, RandomSource rand) {
        for (int i = 0; i < trial; ++i) {
            this.rand(ip, p, br, rand);
            BlockState state = level.getBlockState((BlockPos)p);
            if (!state.is(this.target)) continue;
            new Entry(level, p.immutable()).put();
        }
    }

    private void rand(BlockPos o, BlockPos.MutableBlockPos p, int r, RandomSource rand) {
        int bx = o.getX() + rand.nextIntBetweenInclusive(-r, r);
        int bz = o.getZ() + rand.nextIntBetweenInclusive(-r, r);
        int by = this.maxY < this.minY + r * 2 ? rand.nextIntBetweenInclusive(this.minY, this.maxY) : Math.clamp((long)o.getY(), this.minY + r, this.maxY - r) + rand.nextIntBetweenInclusive(-r, r);
        p.set(bx, by, bz);
    }

    public void render() {
        for (BlockPos e : this.map.keySet()) {
            ClientEffectRenderEvents.addIcon((IDelayedRender)SimpleIcon.of((ResourceLocation)this.source.id(), (Vec3)e.getCenter()));
        }
    }

    public int count() {
        return this.map.size();
    }

    private class Entry {
        private final Level level;
        private final BlockPos pos;
        private int life = 600;

        private Entry(Level level, BlockPos pos) {
            this.level = level;
            this.pos = pos;
        }

        public void put() {
            if (BlockSearcher.this.map.size() >= 99) {
                return;
            }
            BlockSearcher.this.map.put(this.pos, this);
        }

        public boolean shouldRemove(Player player, Level level) {
            if (level != this.level) {
                return true;
            }
            BlockPos p = player.blockPosition();
            int rad = BlockSearcher.this.radius.getAsInt();
            BlockPos blockPos = new BlockPos(p.getX(), this.pos.getY(), p.getZ());
            if (this.pos.distSqr((Vec3i)blockPos) > (double)(rad * rad)) {
                return true;
            }
            if (!level.getBlockState(this.pos).is(BlockSearcher.this.target)) {
                return true;
            }
            --this.life;
            return this.life <= 0;
        }
    }
}

