/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.core.description;

import dev.xkmc.glimmeringtales.content.engine.instance.GTKnockBlock;
import dev.xkmc.glimmeringtales.content.engine.instance.LightningInstance;
import dev.xkmc.glimmeringtales.content.engine.processor.PassiveHealProcessor;
import dev.xkmc.glimmeringtales.content.engine.processor.StackingEffectProcessor;
import dev.xkmc.glimmeringtales.init.data.GTLang;
import dev.xkmc.glimmeringtales.init.reg.GTEngine;
import dev.xkmc.l2magic.content.engine.core.EngineType;
import dev.xkmc.l2magic.content.engine.core.ProcessorType;
import dev.xkmc.l2magic.content.engine.extension.Extension;
import dev.xkmc.l2magic.content.engine.processor.DamageProcessor;
import dev.xkmc.l2magic.content.engine.processor.EffectProcessor;
import dev.xkmc.l2magic.init.registrate.EngineRegistry;
import java.util.OptionalDouble;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringUtil;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.neoforged.neoforge.common.Tags;

public class SpellTooltipRegistry {
    public static void init() {
        ((ProcessorType)EngineRegistry.DAMAGE.get()).add((Extension)new DamageTooltip());
        ((ProcessorType)EngineRegistry.EFFECT.get()).add((Extension)new EffectTooltip());
        ((EngineType)GTEngine.KNOCK.get()).add((Extension)new FallingTooltip());
        ((ProcessorType)GTEngine.EP_STACK.get()).add((Extension)new StackingTooltip());
        ((EngineType)GTEngine.THUNDER.get()).add((Extension)new LightningTooltip());
        ((ProcessorType)GTEngine.HEAL.get()).add((Extension)new HealTooltip());
    }

    private static Component getTooltip(Holder<MobEffect> eff, int amp, int dur) {
        MutableComponent ans = Component.translatable((String)((MobEffect)eff.value()).getDescriptionId());
        MobEffect mobeffect = (MobEffect)eff.value();
        if (amp > 0) {
            ans = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{ans, Component.translatable((String)("potion.potency." + amp))});
        }
        if (dur > 20) {
            ans = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{ans, Component.literal((String)StringUtil.formatTickDuration((int)dur, (float)20.0f))});
        }
        return ans.withStyle(mobeffect.getCategory().getTooltipFormatting());
    }

    static class DamageTooltip
    extends Tooltip<DamageProcessor> {
        DamageTooltip() {
        }

        public Component process(DamageProcessor e) {
            OptionalDouble dmg = e.damage().exp().getAsConstant();
            Holder type = e.damageType();
            MutableComponent ans = DamageTooltip.damageStart(dmg);
            this.test(ans, (Holder<DamageType>)type, (TagKey<DamageType>)DamageTypeTags.IS_FIRE, GTLang.DESC_FIRE, ChatFormatting.RED);
            this.test(ans, (Holder<DamageType>)type, (TagKey<DamageType>)DamageTypeTags.IS_EXPLOSION, GTLang.DESC_EXPLOSION, ChatFormatting.GOLD);
            this.test(ans, (Holder<DamageType>)type, (TagKey<DamageType>)DamageTypeTags.IS_FREEZING, GTLang.DESC_FREEZING, ChatFormatting.AQUA);
            this.test(ans, (Holder<DamageType>)type, (TagKey<DamageType>)DamageTypeTags.IS_PROJECTILE, GTLang.DESC_PROJECTILE, ChatFormatting.WHITE);
            this.test(ans, (Holder<DamageType>)type, (TagKey<DamageType>)DamageTypeTags.IS_LIGHTNING, GTLang.DESC_LIGHTNING, ChatFormatting.YELLOW);
            this.test(ans, (Holder<DamageType>)type, (TagKey<DamageType>)Tags.DamageTypes.IS_MAGIC, GTLang.DESC_MAGIC, ChatFormatting.LIGHT_PURPLE);
            return ans.append((Component)GTLang.DESC_DAMAGE.get(new Object[0]));
        }

        private void test(MutableComponent ans, Holder<DamageType> type, TagKey<DamageType> key, GTLang lang, ChatFormatting formatting) {
            if (type.is(key)) {
                ans.append((Component)lang.get(new Object[0]).withStyle(formatting)).append((Component)GTLang.DESC_SPACE.get(new Object[0]));
            }
        }
    }

    static class EffectTooltip
    extends Tooltip<EffectProcessor> {
        EffectTooltip() {
        }

        public Component process(EffectProcessor e) {
            int amp = (int)e.amplifier().exp().getAsConstant().orElse(0.0);
            int dur = (int)e.duration().exp().getAsConstant().orElse(0.0);
            Holder eff = e.eff();
            return SpellTooltipRegistry.getTooltip((Holder<MobEffect>)eff, amp, dur);
        }
    }

    static class FallingTooltip
    extends Tooltip<GTKnockBlock> {
        FallingTooltip() {
        }

        public Component process(GTKnockBlock e) {
            OptionalDouble dpb = e.damagePerBlock().exp().getAsConstant();
            OptionalDouble max = e.maxDamage().exp().getAsConstant();
            OptionalDouble spe = e.speed().exp().getAsConstant();
            OptionalDouble dmg = OptionalDouble.empty();
            if (dpb.isPresent() && spe.isPresent() && max.isPresent()) {
                dmg = OptionalDouble.of(this.damage(dpb.getAsDouble(), spe.getAsDouble(), max.getAsDouble()));
            }
            MutableComponent ans = FallingTooltip.damageStart(dmg);
            ans.append((Component)GTLang.DESC_FALLING_BLOCK.get(new Object[0]).withStyle(ChatFormatting.RED)).append((Component)GTLang.DESC_SPACE.get(new Object[0]));
            return ans.append((Component)GTLang.DESC_DAMAGE.get(new Object[0]));
        }

        private double damage(double dpb, double spe, double max) {
            double g = 0.04;
            double f = 0.02;
            double p = g / f;
            double t = Math.log(spe / p + 1.0) / f;
            double h = (spe - g * t) / f;
            return h < 1.0 ? 0.0 : Math.min(max, dpb * (h - 1.0));
        }
    }

    static class StackingTooltip
    extends Tooltip<StackingEffectProcessor> {
        StackingTooltip() {
        }

        public Component process(StackingEffectProcessor e) {
            int dur = (int)e.duration().exp().getAsConstant().orElse(0.0);
            Holder<MobEffect> eff = e.eff();
            return SpellTooltipRegistry.getTooltip(eff, 0, dur);
        }
    }

    static class LightningTooltip
    extends Tooltip<LightningInstance> {
        LightningTooltip() {
        }

        public Component process(LightningInstance e) {
            OptionalDouble dmg = e.damage().exp().getAsConstant();
            MutableComponent ans = LightningTooltip.damageStart(dmg);
            ans.append((Component)GTLang.DESC_LIGHTNING.get(new Object[0]).withStyle(ChatFormatting.YELLOW)).append((Component)GTLang.DESC_SPACE.get(new Object[0]));
            return ans.append((Component)GTLang.DESC_DAMAGE.get(new Object[0]));
        }
    }

    static class HealTooltip
    extends Tooltip<PassiveHealProcessor> {
        HealTooltip() {
        }

        public Component process(PassiveHealProcessor e) {
            OptionalDouble dur = e.interval().exp().getAsConstant();
            OptionalDouble val = e.heal().exp().getAsConstant();
            MutableComponent comp = GTLang.HP.get(new Object[0]);
            if (dur.isPresent() && val.isPresent()) {
                int ans = (int)(20.0 * val.getAsDouble() / dur.getAsDouble());
                comp = Component.empty().append((Component)Component.literal((String)("" + ans)).withStyle(ChatFormatting.AQUA)).append((Component)GTLang.DESC_SPACE.get(new Object[0])).append((Component)comp);
            }
            return GTLang.DESC_HEAL.get(comp).withStyle(ChatFormatting.GRAY);
        }
    }

    public static abstract class Tooltip<T>
    extends Extension<Component, T> {
        public Tooltip() {
            super(Component.class);
        }

        protected static MutableComponent damageStart(OptionalDouble dmg) {
            return dmg.isEmpty() ? Component.empty() : GTLang.DESC_DMG.get(Component.literal((String)("" + (int)dmg.getAsDouble())).withStyle(ChatFormatting.DARK_AQUA)).append((Component)GTLang.DESC_SPACE.get(new Object[0]));
        }
    }
}

