/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.core.description;

import dev.xkmc.glimmeringtales.content.core.description.SpellDataStack;
import dev.xkmc.glimmeringtales.content.core.description.SpellTooltip;
import dev.xkmc.glimmeringtales.init.reg.GTEngine;
import dev.xkmc.l2core.init.reg.simple.Val;
import dev.xkmc.l2magic.content.engine.extension.Extension;
import dev.xkmc.l2magic.content.engine.extension.ExtensionHolder;
import dev.xkmc.l2magic.content.engine.extension.IExtended;
import dev.xkmc.l2magic.init.registrate.EngineRegistry;
import dev.xkmc.l2serial.util.Wrappers;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public record SpellTooltipData(ArrayList<Entry> list) {
    public static SpellTooltipData damage() {
        return SpellTooltipData.of(EngineRegistry.DAMAGE);
    }

    public static SpellTooltipData damageAndFalling() {
        return SpellTooltipData.of(EngineRegistry.DAMAGE, GTEngine.KNOCK);
    }

    public static SpellTooltipData damageAndEffect() {
        return SpellTooltipData.of(EngineRegistry.DAMAGE, EngineRegistry.EFFECT);
    }

    public static SpellTooltipData of() {
        return new SpellTooltipData(new ArrayList<Entry>());
    }

    @SafeVarargs
    public static SpellTooltipData of(Val<? extends ExtensionHolder<?>> ... entries) {
        return new SpellTooltipData(new ArrayList<Entry>(Stream.of(entries).map(Entry::of).toList()));
    }

    public static String brief(ResourceLocation rl) {
        return "nature_spell." + rl.toLanguageKey() + ".brief";
    }

    public static String detail(ResourceLocation rl) {
        return "nature_spell." + rl.toLanguageKey() + ".detail";
    }

    public Component format(ResourceLocation rl, SpellTooltip data) {
        SpellDataStack stack = data.asStack();
        Object[] objs = new Object[this.list.size()];
        for (int i = 0; i < this.list.size(); ++i) {
            objs[i] = SpellTooltipData.format(this.list.get(i).type(), stack);
        }
        return Component.translatable((String)SpellTooltipData.detail(rl), (Object[])objs).withStyle(ChatFormatting.GRAY);
    }

    public void brief(ResourceLocation rl, List<Component> ans, SpellTooltip data) {
        SpellDataStack stack = data.asStack();
        ans.add((Component)Component.empty());
        ans.add((Component)Component.translatable((String)SpellTooltipData.brief(rl)).withStyle(ChatFormatting.GRAY));
        for (Entry e : this.list()) {
            ans.add((Component)Component.literal((String)"=> ").append(SpellTooltipData.format(e.type(), stack)).withStyle(ChatFormatting.GRAY));
        }
    }

    public static <T extends IExtended<T>> Component format(ExtensionHolder<T> type, SpellDataStack data) {
        Extension ext = type.get(Component.class);
        return ext == null ? Component.literal((String)"???") : (Component)ext.process(data.get(type));
    }

    public record Entry(ResourceLocation reg, ResourceLocation id) {
        public static Entry of(Val<? extends ExtensionHolder<?>> val) {
            return new Entry(val.key().registry(), val.key().location());
        }

        public ExtensionHolder<?> type() {
            return (ExtensionHolder)Wrappers.cast((Object)((Registry)BuiltInRegistries.REGISTRY.get(this.reg)).get(this.id));
        }
    }
}

