/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.core.description;

import dev.xkmc.glimmeringtales.content.core.description.SpellDataStack;
import dev.xkmc.glimmeringtales.content.core.description.SpellTooltipData;
import dev.xkmc.glimmeringtales.content.core.spell.NatureSpell;
import dev.xkmc.l2magic.content.engine.core.Verifiable;
import dev.xkmc.l2magic.content.engine.extension.Extension;
import dev.xkmc.l2magic.content.engine.extension.ExtensionEntry;
import dev.xkmc.l2magic.content.engine.extension.ExtensionHolder;
import dev.xkmc.l2magic.content.engine.extension.ExtensionKey;
import dev.xkmc.l2magic.content.engine.extension.ExtensionTypeManager;
import dev.xkmc.l2magic.content.engine.extension.IExtended;
import dev.xkmc.l2magic.content.engine.spell.SpellAction;
import dev.xkmc.l2serial.util.Wrappers;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class SpellTooltip
extends ExtensionEntry<SpellTooltip, DescHolder> {
    private static final ExtensionTypeManager<SpellTooltip, DescHolder> MANAGER = new ExtensionTypeManager();
    private final SpellTooltipData components;
    private final LinkedHashMap<ExtensionHolder<?>, List<IExtended<?>>> map = new LinkedHashMap();

    public static SpellTooltip get(Level level, NatureSpell spell) {
        return (SpellTooltip)MANAGER.get((ExtensionKey)new DescHolder(spell));
    }

    public SpellTooltip(Verifiable spell, SpellTooltipData components) {
        super(spell);
        this.components = components;
        this.analyze();
    }

    public boolean match(DescHolder holder) {
        return this.entry == holder.getEntry() && this.components == holder.spell().tooltip();
    }

    protected void initAnalysis() {
        this.map.clear();
        for (SpellTooltipData.Entry e : this.components.list()) {
            this.map.put(e.type(), new ArrayList());
        }
    }

    protected void process(IExtended<?> p) {
        if (this.map.containsKey(p.type())) {
            this.map.get(p.type()).add(p);
        }
    }

    public Component format(ResourceKey<NatureSpell> key) {
        return this.components.format(key.location(), this);
    }

    public void brief(ResourceKey<NatureSpell> key, List<Component> list) {
        this.components.brief(key.location(), list, this);
    }

    public void verify() {
        SpellDataStack stack = this.asStack();
        for (int i = 0; i < this.components.list().size(); ++i) {
            ExtensionHolder<?> type = this.components.list().get(i).type();
            Extension ext = type.get(Component.class);
            ext.process((Object)((IExtended)Wrappers.cast(stack.get(type))));
        }
    }

    public SpellDataStack asStack() {
        LinkedHashMap ans = new LinkedHashMap();
        for (Map.Entry<ExtensionHolder<?>, List<IExtended<?>>> ent : this.map.entrySet()) {
            ans.put(ent.getKey(), new ArrayDeque(ent.getValue()));
        }
        return new SpellDataStack(ans);
    }

    public record DescHolder(NatureSpell spell) implements ExtensionKey<SpellTooltip, DescHolder>
    {
        public Verifiable getEntry() {
            return ((SpellAction)this.spell.spell().value()).action();
        }

        public SpellTooltip create() {
            return new SpellTooltip(this.getEntry(), this.spell.tooltip());
        }
    }
}

