/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.capability;

import dev.xkmc.glimmeringtales.content.core.spell.SpellCost;
import dev.xkmc.glimmeringtales.init.reg.GTRegistries;
import dev.xkmc.l2core.capability.player.PlayerCapabilityHolder;
import dev.xkmc.l2core.capability.player.PlayerCapabilityTemplate;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;

@SerialClass
public class PlayerManaCapability
extends PlayerCapabilityTemplate<PlayerManaCapability> {
    @SerialField
    private double mana = ((Attribute)GTRegistries.MAX_MANA.get()).getDefaultValue();
    @SerialField
    private double focus = ((Attribute)GTRegistries.MAX_FOCUS.get()).getDefaultValue();
    @SerialField
    private int focusCoolDown = 0;

    public void onClone(Player player, boolean isWasDeath) {
        if (isWasDeath) {
            this.mana = player.getAttributeValue(GTRegistries.MAX_MANA);
            this.focus = ((Attribute)GTRegistries.MAX_FOCUS.get()).getDefaultValue();
        }
    }

    public void tick(Player player) {
        double maxFocus;
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            if (sp.tickCount % 20 == 0) {
                double max = sp.getAttributeValue(GTRegistries.MAX_MANA);
                double regen = sp.getAttributeValue(GTRegistries.MANA_REGEN);
                if (this.mana >= max) {
                    this.mana = max;
                } else {
                    if (!(this.mana >= 0.0)) {
                        this.mana = 0.0;
                    }
                    this.mana = Math.min(max, this.mana + regen);
                    ((PlayerCapabilityHolder)GTRegistries.MANA.type()).network.toClient(sp);
                }
            }
        }
        if (this.focus > (maxFocus = player.getAttributeValue(GTRegistries.MAX_FOCUS))) {
            this.focus = maxFocus;
        }
        if (!(this.focus >= 0.0)) {
            this.focus = 0.0;
        }
        if (this.focusCoolDown > 0) {
            --this.focusCoolDown;
        } else if (this.focusCoolDown == 0 && this.focus < maxFocus) {
            this.focus = Math.min(maxFocus, this.focus + 1.0);
            if (this.focus == maxFocus && player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                ((PlayerCapabilityHolder)GTRegistries.MANA.type()).network.toClient(sp);
            }
        }
    }

    public double getMana() {
        return this.mana;
    }

    public boolean consume(Player player, SpellCost cost) {
        if (cost.focus() > this.focus || cost.mana() > this.mana) {
            return false;
        }
        this.focus -= cost.focus();
        this.mana -= cost.mana();
        this.focusCoolDown = (int)player.getAttributeValue(GTRegistries.FOCUS_CD);
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            ((PlayerCapabilityHolder)GTRegistries.MANA.type()).network.toClient(sp);
        }
        return true;
    }

    public double getFocus() {
        return this.focus;
    }
}

