/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.block.ritual;

import dev.xkmc.glimmeringtales.content.block.altar.CoreRitualBlockEntity;
import dev.xkmc.glimmeringtales.content.block.altar.SideRitualBlockEntity;
import dev.xkmc.glimmeringtales.content.block.ritual.MatrixAnimationState;
import dev.xkmc.glimmeringtales.content.recipe.ritual.RitualInput;
import dev.xkmc.glimmeringtales.content.recipe.ritual.RitualRecipe;
import dev.xkmc.glimmeringtales.init.reg.GTRecipes;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

@SerialClass
public class NatureCoreBlockEntity
extends CoreRitualBlockEntity {
    @SerialField
    private int totalTime;
    @SerialField
    private int remainTime;
    @SerialField
    private long lastTimeStamp;
    @SerialField
    private ResourceLocation recipeId;
    private RitualRecipe<?> recipe;
    private final MatrixAnimationState animation = new MatrixAnimationState();

    public NatureCoreBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public float getTime(float pTick) {
        return this.animation.getTime(pTick);
    }

    @Override
    public void tick() {
        super.tick();
        this.tickCraft();
        if (this.level != null && this.level.isClientSide()) {
            this.tickParticle();
        }
    }

    private void laps() {
        this.lastTimeStamp = this.level == null ? 0L : this.level.getGameTime();
    }

    public void triggerCraft() {
        if (this.level == null || this.level.isClientSide || this.remainTime > 0) {
            return;
        }
        RitualInput input = new RitualInput(this, this.getLinked());
        Optional opt = this.level.getRecipeManager().getRecipeFor((RecipeType)GTRecipes.RT_RITUAL.get(), (RecipeInput)input, this.level);
        if (opt.isEmpty()) {
            return;
        }
        this.recipeId = ((RecipeHolder)opt.get()).id();
        this.recipe = (RitualRecipe)((RecipeHolder)opt.get()).value();
        this.totalTime = this.remainTime = this.recipe.getTime();
        this.laps();
        this.sync();
        this.setChanged();
    }

    private void tickCraft() {
        if (this.level == null || this.level.isClientSide() || this.remainTime <= 0) {
            return;
        }
        boolean update = false;
        if (this.recipeId == null || this.recipe == null) {
            RitualInput input = new RitualInput(this, this.getLinked());
            Optional opt = this.level.getRecipeManager().getRecipeFor((RecipeType)GTRecipes.RT_RITUAL.get(), (RecipeInput)input, this.level);
            if (opt.isEmpty()) {
                this.onLinkBreak();
                return;
            }
            this.recipeId = ((RecipeHolder)opt.get()).id();
            this.recipe = (RitualRecipe)((RecipeHolder)opt.get()).value();
            update = true;
        }
        if (this.remainTime % 114514 == this.totalTime % 114514) {
            this.level.playSound(null, this.getBlockPos(), SoundEvents.PORTAL_TRIGGER, SoundSource.BLOCKS, 1.0f, 0.78f);
        }
        --this.remainTime;
        if (this.remainTime <= 0) {
            this.recipe.assemble(new RitualInput(this, this.getLinked()), (HolderLookup.Provider)this.level.registryAccess());
            this.laps();
            this.remainTime = 0;
            this.totalTime = 0;
            this.recipeId = null;
            this.recipe = null;
            update = true;
            this.level.playSound(null, this.getBlockPos(), SoundEvents.VAULT_OPEN_SHUTTER, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (update) {
            this.sync();
            this.setChanged();
        }
    }

    private void tickParticle() {
        if (this.level == null) {
            return;
        }
        if (this.animation.tick(this.totalTime > 0)) {
            if (this.totalTime > 0) {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                list.add(this.getItem().copy());
                for (SideRitualBlockEntity e : this.getLinked()) {
                    list.add(e.getItem().copy());
                }
                this.animation.setup(list);
            } else {
                this.animation.release(this.level, this.getBlockPos(), this);
            }
        }
        Vec3 pos = this.getBlockPos().getCenter().add(0.0, 2.0, 0.0);
        for (SideRitualBlockEntity e : this.getLinked()) {
            Vec3 ip = e.getBlockPos().getCenter().add(0.0, 1.0, 0.0).subtract(pos);
            if (this.remainTime <= 0 && this.level.getRandom().nextInt(8) != 0) continue;
            this.level.addParticle((ParticleOptions)ParticleTypes.ENCHANT, pos.x, pos.y, pos.z, ip.x, ip.y, ip.z);
        }
    }

    @Override
    public boolean locked() {
        return this.remainTime > 0;
    }

    @Override
    public void onLinkBreak() {
        this.remainTime = 0;
        this.totalTime = 0;
        this.recipeId = null;
        this.recipe = null;
        this.laps();
        this.sync();
        this.setChanged();
    }

    public float progress(float pTick) {
        if (this.totalTime > 0) {
            long time = this.level == null ? 0L : this.level.getGameTime();
            float lap = Math.min((float)this.totalTime, (float)(time - this.lastTimeStamp) + pTick);
            return 1.0f - lap / (float)this.totalTime;
        }
        return 1.0f;
    }
}

