/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.block.ritual;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.xkmc.glimmeringtales.content.block.ritual.NatureCoreBlockEntity;
import dev.xkmc.glimmeringtales.content.block.ritual.RitualRenderer;
import dev.xkmc.glimmeringtales.init.GlimmeringTales;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import org.joml.Quaternionf;

public class MatrixRenderer<T extends NatureCoreBlockEntity>
extends RitualRenderer<T> {
    private static final ResourceLocation END_CRYSTAL_LOCATION = GlimmeringTales.loc("textures/entity/ritual_matrix.png");
    private static final RenderType RENDER_TYPE = RenderType.entityCutoutNoCull((ResourceLocation)END_CRYSTAL_LOCATION);
    private static final float SIN_45 = (float)Math.sin(0.7853981633974483);
    private final ModelPart glass;

    public MatrixRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        ModelPart modelpart = context.bakeLayer(ModelLayers.END_CRYSTAL);
        this.glass = modelpart.getChild("glass");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("glass", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    @Override
    public void render(T be, float pTick, PoseStack pose, MultiBufferSource buffer, int light, int overlay) {
        super.render(be, pTick, pose, buffer, light, overlay);
        light = 0xF000F0;
        pose.pushPose();
        float f1 = ((NatureCoreBlockEntity)((Object)be)).getTime(pTick);
        float f2 = 0.8f;
        VertexConsumer vc = buffer.getBuffer(RENDER_TYPE);
        pose.pushPose();
        pose.translate(0.5f, -0.5f, 0.5f);
        pose.scale(2.0f, 2.0f, 2.0f);
        pose.translate(0.0f, -0.5f, 0.0f);
        pose.mulPose(Axis.YP.rotationDegrees(f1));
        pose.translate(0.0f, 1.5f, 0.0f);
        pose.mulPose(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
        this.glass.render(pose, vc, light, overlay);
        pose.scale(f2, f2, f2);
        pose.mulPose(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
        pose.mulPose(Axis.YP.rotationDegrees(f1));
        this.glass.render(pose, vc, light, overlay);
        pose.scale(f2, f2, f2);
        pose.mulPose(new Quaternionf().setAngleAxis(1.5707964f, SIN_45, 0.0f, SIN_45));
        pose.mulPose(Axis.YP.rotationDegrees(f1));
        this.glass.render(pose, vc, light, overlay);
        pose.popPose();
        pose.popPose();
    }

    public AABB getRenderBoundingBox(T be) {
        BlockPos pos = be.getBlockPos();
        return new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 2), (double)(pos.getZ() + 1));
    }
}

