/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.block.ritual;

import dev.xkmc.glimmeringtales.content.block.ritual.MatrixParticleHelper;
import dev.xkmc.glimmeringtales.content.block.ritual.NatureCoreBlockEntity;
import dev.xkmc.glimmeringtales.content.core.spell.ElementAffinity;
import dev.xkmc.glimmeringtales.content.core.spell.SpellElement;
import dev.xkmc.glimmeringtales.content.item.rune.SpellCoreItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MatrixAnimationState {
    private static final int MIN_SPEED = 4;
    private static final int MAX_SPEED = 44;
    private static final float W = 0.75f;
    private final List<ItemStack> cachedStacks = new ArrayList<ItemStack>();
    private int speed = 4;
    private int nextSpeed = 4;
    private float angle = 0.0f;
    private boolean prevState = false;

    public float getTime(float pTick) {
        int diff = this.nextSpeed - this.speed;
        return this.angle + 0.75f * (float)this.speed * pTick * (1.0f + (float)diff * pTick / 2.0f);
    }

    public boolean tick(boolean crafting) {
        boolean change = this.prevState != crafting;
        int diff = this.nextSpeed - this.speed;
        this.angle += 0.75f * (float)this.speed * (1.0f + (float)diff / 2.0f);
        this.speed = this.nextSpeed;
        this.nextSpeed = crafting ? Math.min(44, this.speed + 1) : Math.max(4, this.speed - 1);
        this.prevState = crafting;
        return change;
    }

    public void setup(List<ItemStack> list) {
        this.cachedStacks.clear();
        this.cachedStacks.addAll(list);
    }

    public void release(Level level, BlockPos pos, NatureCoreBlockEntity be) {
        SpellCoreItem item;
        ElementAffinity aff;
        Item item2;
        int col = -1;
        if (!this.cachedStacks.isEmpty() && (item2 = this.cachedStacks.getFirst().getItem()) instanceof SpellCoreItem && (aff = (item = (SpellCoreItem)item2).getAffinity(level)) != null && aff.affinity().size() == 1) {
            SpellElement e = new ArrayList<Map.Entry<SpellElement, Double>>(aff.affinity().entrySet()).getFirst().getKey();
            col = e.getColor();
        }
        Vec3 center = pos.above().getCenter();
        MatrixParticleHelper.complete(level, center, col);
        this.cachedStacks.clear();
    }
}

