/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.block.misc;

import dev.xkmc.glimmeringtales.init.data.GTLang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class StruckLogBlock
extends RotatedPillarBlock {
    public StruckLogBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onCaughtFire(BlockState state, Level level, BlockPos pos, @Nullable Direction direction, @Nullable LivingEntity igniter) {
        ServerPlayer sp;
        if (!level.canSeeSky(pos.above())) {
            return;
        }
        level.removeBlock(pos, false);
        LightningBolt bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level);
        assert (bolt != null);
        bolt.addTag("l2library:safe_lightning");
        bolt.moveTo(Vec3.atBottomCenterOf((Vec3i)pos));
        bolt.setCause(igniter instanceof ServerPlayer ? (sp = (ServerPlayer)igniter) : null);
        level.addFreshEntity((Entity)bolt);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!stack.is(Items.FLINT_AND_STEEL) && !stack.is(Items.FIRE_CHARGE)) {
            return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        }
        this.onCaughtFire(state, level, pos, hitResult.getDirection(), (LivingEntity)player);
        Item item = stack.getItem();
        if (stack.is(Items.FLINT_AND_STEEL)) {
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
        } else {
            stack.consume(1, (LivingEntity)player);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)item));
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (!level.isClientSide) {
            BlockPos blockpos = hit.getBlockPos();
            Entity entity = projectile.getOwner();
            if (projectile.isOnFire() && projectile.mayInteract(level, blockpos)) {
                LivingEntity e;
                this.onCaughtFire(state, level, blockpos, null, entity instanceof LivingEntity ? (e = (LivingEntity)entity) : null);
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        list.add((Component)GTLang.TOOLTIP_STRUCK.get(new Object[0]).withStyle(ChatFormatting.GRAY));
    }
}

