/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.block.crop;

import dev.xkmc.glimmeringtales.content.block.crop.AbstractPopFruit;
import dev.xkmc.glimmeringtales.content.block.crop.NaturalPopFruit;
import dev.xkmc.glimmeringtales.content.block.crop.PopFruitClient;
import dev.xkmc.glimmeringtales.content.item.materials.IFoodItem;
import dev.xkmc.glimmeringtales.init.data.GTConfigs;
import dev.xkmc.glimmeringtales.init.data.GTLang;
import dev.xkmc.l2library.content.explosion.BaseExplosion;
import dev.xkmc.l2library.content.explosion.BaseExplosionContext;
import dev.xkmc.l2library.content.explosion.ExplosionHandler;
import dev.xkmc.l2library.content.explosion.ParticleExplosionContext;
import dev.xkmc.l2library.content.explosion.VanillaExplosionContext;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;

public class PopFruitItem
extends ItemNameBlockItem {
    public PopFruitItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity le) {
        AbstractPopFruit pop;
        ItemStack ans;
        block5: {
            block4: {
                ans = super.finishUsingItem(stack, level, le);
                if (level.isClientSide) {
                    return ans;
                }
                double rate = GTConfigs.SERVER.popFruitExplosionChanceOnEaten.getAsDouble();
                Block block = this.getBlock();
                if (!(block instanceof AbstractPopFruit)) break block4;
                pop = (AbstractPopFruit)block;
                if (!(le.getRandom().nextDouble() > rate)) break block5;
            }
            return ans;
        }
        ExplosionHandler.explode((BaseExplosion)new BaseExplosion(new BaseExplosionContext(level, le.getX(), le.getEyeY() - 0.1, le.getZ(), 1.0f), new VanillaExplosionContext(null, null, null, false, Explosion.BlockInteraction.KEEP), pop::onExplosionAffecting, ParticleExplosionContext.of((float)1.0f)));
        pop.onExplode(level, BlockPos.containing((double)le.getX(), (double)(le.getEyeY() - 0.1), (double)le.getZ()), 1);
        return ans;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        IFoodItem.getFoodEffects(stack, list);
        double rate = GTConfigs.SERVER.popFruitExplosionChanceOnEaten.getAsDouble();
        int perc = (int)Math.round(rate * 100.0);
        list.add((Component)GTLang.CHANCE_EXPLODE.get(perc).withStyle(ChatFormatting.RED));
        Block block = this.getBlock();
        if (block instanceof AbstractPopFruit) {
            AbstractPopFruit pop = (AbstractPopFruit)block;
            MutableComponent plantable = (pop instanceof LiquidBlockContainer ? GTLang.PLANTABLE_WATER.get(new Object[0]) : GTLang.PLANTABLE.get(new Object[0])).withStyle(ChatFormatting.GRAY);
            boolean first = true;
            for (Block e : pop.plantableOn()) {
                if (first) {
                    first = false;
                } else {
                    plantable = plantable.append(", ");
                }
                plantable = plantable.append((Component)Component.translatable((String)e.getDescriptionId()).withStyle(ChatFormatting.GRAY));
            }
            list.add((Component)plantable);
            if (pop instanceof NaturalPopFruit) {
                NaturalPopFruit natural = (NaturalPopFruit)pop;
                list.add((Component)GTLang.SPAWN.get(natural.getBiomeDesc().withStyle(ChatFormatting.DARK_GREEN)).withStyle(ChatFormatting.GRAY));
                Level level = context.level();
                if (level != null && level.isClientSide()) {
                    PopFruitClient.appendBiomeInfo(list, level, natural);
                }
            }
        }
    }
}

