/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.block.crop;

import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import dev.xkmc.glimmeringtales.content.block.crop.AbstractPopFruit;
import dev.xkmc.glimmeringtales.content.block.crop.NaturalPopFruit;
import dev.xkmc.glimmeringtales.init.data.GTLang;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import org.jetbrains.annotations.Nullable;

public class OceanPopFruit
extends NaturalPopFruit
implements LiquidBlockContainer {
    public static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)3.0, (double)10.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0)};

    private static int getLight(BlockState state) {
        return (Integer)state.getValue((Property)AGE) * 3;
    }

    public OceanPopFruit(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(OceanPopFruit::getLight));
    }

    @Override
    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is(BlockTags.DIRT) || state.is(Blocks.GRAVEL) || state.is(Blocks.SAND) || super.mayPlaceOn(state, level, pos);
    }

    @Override
    protected boolean canSurviveLight(LevelReader level, BlockPos pos) {
        return true;
    }

    @Override
    public List<Block> plantableOn() {
        return List.of(Blocks.DIRT, Blocks.GRAVEL, Blocks.SAND);
    }

    @Override
    public MutableComponent getBiomeDesc() {
        return GTLang.BIOME_OCEAN.get(new Object[0]);
    }

    @Override
    protected boolean onExplosionAffecting(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            le.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 200, 0));
        }
        return super.onExplosionAffecting(entity);
    }

    @Override
    protected void onExplode(Level level, BlockPos pos, int r) {
        super.onExplode(level, pos, r);
    }

    @Override
    public void buildState(DataGenContext<Block, ? extends AbstractPopFruit> ctx, RegistrateBlockstateProvider pvd) {
        pvd.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
            int age = (Integer)state.getValue((Property)AGE);
            String id = ctx.getName() + "_" + age;
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().withExistingParent(id, pvd.modLoc("custom/crop/" + id))).texture("all", "block/crop/" + id)).texture("particle", "block/crop/" + ctx.getName() + "_particle")).renderType("translucent")).build();
        });
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[this.getAge(state)];
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        FluidState fluid = ctx.getLevel().getFluidState(ctx.getClickedPos());
        return fluid.is(FluidTags.WATER) && fluid.getAmount() == 8 ? super.getStateForPlacement(ctx) : null;
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BlockState blockstate = super.updateShape(state, direction, neighborState, level, pos, neighborPos);
        if (!blockstate.isAir()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return blockstate;
    }

    protected FluidState getFluidState(BlockState p_154537_) {
        return Fluids.WATER.getSource(false);
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return false;
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        return false;
    }
}

