/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.block.crop;

import com.mojang.serialization.MapCodec;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import dev.xkmc.glimmeringtales.content.block.api.CropGrowListener;
import dev.xkmc.glimmeringtales.init.data.GTLang;
import dev.xkmc.glimmeringtales.init.reg.GTItems;
import dev.xkmc.l2core.serial.loot.LootHelper;
import dev.xkmc.l2harvester.api.HarvestResult;
import dev.xkmc.l2harvester.api.HarvestableBlock;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.Nullable;

public class LifeCrystalCrop
extends CropBlock
implements CropGrowListener,
HarvestableBlock {
    public static final MapCodec<LifeCrystalCrop> CODEC = LifeCrystalCrop.simpleCodec(LifeCrystalCrop::new);
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0)};

    public LifeCrystalCrop(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        list.add((Component)GTLang.TOOLTIP_VINE.get(new Object[0]).withStyle(ChatFormatting.GRAY));
    }

    @Nullable
    public HarvestResult getHarvestResult(Level level, BlockState state, BlockPos blockPos) {
        if ((Integer)state.getValue((Property)AGE) < this.getMaxAge()) {
            return null;
        }
        return new HarvestResult(Blocks.AIR.defaultBlockState(), List.of(GTItems.CRYSTAL_LIFE.asStack()));
    }

    public MapCodec<LifeCrystalCrop> codec() {
        return CODEC;
    }

    protected ItemLike getBaseSeedId() {
        return GTItems.CRYSTAL_VINE.asItem();
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[this.getAge(state)];
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
    }

    @Override
    public void onNeighborGrow(ServerLevel level, BlockState state, BlockPos pos, BlockState source) {
        CropBlock block;
        Block block2 = source.getBlock();
        if (block2 instanceof CropBlock && (block = (CropBlock)block2).getAge(source) == block.getMaxAge()) {
            int i = this.getAge(state);
            if (i >= this.getMaxAge()) {
                return;
            }
            if (CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (boolean)true)) {
                level.setBlock(pos, this.getStateForAge(i + 1), 2);
                CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return false;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
    }

    public static void buildState(DataGenContext<Block, LifeCrystalCrop> ctx, RegistrateBlockstateProvider pvd) {
        pvd.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
            int age = (Integer)state.getValue((Property)AGE);
            String id = ctx.getName() + "_" + age;
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)pvd.models().cross(id, pvd.modLoc("block/crop/" + id))).renderType("cutout")).build();
        });
    }

    public static void builtLoot(RegistrateBlockLootTables pvd, LifeCrystalCrop block) {
        LootHelper helper = new LootHelper(pvd);
        pvd.add((Block)block, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)GTItems.CRYSTAL_LIFE.asItem()).when(helper.intState((Block)block, (Property)AGE, 7))).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)GTItems.CRYSTAL_VINE.asItem())))));
    }
}

