/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.block.crop;

import com.mojang.serialization.MapCodec;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import dev.xkmc.glimmeringtales.init.data.GTConfigs;
import dev.xkmc.glimmeringtales.init.reg.GTItems;
import dev.xkmc.l2core.serial.loot.LootHelper;
import dev.xkmc.l2library.content.explosion.BaseExplosion;
import dev.xkmc.l2library.content.explosion.BaseExplosionContext;
import dev.xkmc.l2library.content.explosion.ExplosionHandler;
import dev.xkmc.l2library.content.explosion.ParticleExplosionContext;
import dev.xkmc.l2library.content.explosion.VanillaExplosionContext;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.TriState;

public class AbstractPopFruit
extends CropBlock {
    public static final MapCodec<AbstractPopFruit> CODEC = AbstractPopFruit.simpleCodec(AbstractPopFruit::new);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    public static final int MAX_AGE = 3;
    public static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)1.0, (double)9.0), Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0)};

    private static boolean sensitiveTo(Entity e) {
        if (e instanceof LivingEntity) {
            return !(e instanceof Animal);
        }
        if (e instanceof Projectile) {
            return true;
        }
        if (e instanceof FallingBlockEntity) {
            return true;
        }
        return e instanceof VehicleEntity;
    }

    public AbstractPopFruit(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 3;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is(BlockTags.DIRT) || super.mayPlaceOn(state, level, pos);
    }

    public List<Block> plantableOn() {
        return List.of(Blocks.GRASS_BLOCK, Blocks.DIRT);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        TriState soil = level.getBlockState(pos.below()).canSustainPlant((BlockGetter)level, pos.below(), Direction.UP, state);
        if (!soil.isDefault()) {
            return soil.isTrue();
        }
        return this.canSurviveLight(level, pos) && this.mayPlaceOn(level.getBlockState(pos.below()), (BlockGetter)level, pos);
    }

    protected boolean canSurviveLight(LevelReader level, BlockPos pos) {
        return level.getRawBrightness(pos, 0) >= 8;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        int i = this.getAge(state);
        if (i >= this.getMaxAge()) {
            return;
        }
        float f = 1.0f + this.getGrowthSpeedBonus(state, level, pos, random);
        for (Direction dir : Direction.values()) {
            if (dir.getAxis() == Direction.Axis.Y || !level.getBlockState(pos.relative(dir)).is(GTItems.CRYSTAL_VINE)) continue;
            f += (float)GTConfigs.SERVER.popFruitAdjacentCrystalBoost.getAsInt();
        }
        int def = GTConfigs.SERVER.popFruitNaturalGrowRarity.getAsInt();
        if (CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (random.nextInt((int)((float)def / f) + 1) == 0 ? 1 : 0) != 0)) {
            level.setBlock(pos, this.getStateForAge(i + 1), 2);
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    protected float getGrowthSpeedBonus(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        return 0.0f;
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (level.isClientSide()) {
            return;
        }
        if (!AbstractPopFruit.sensitiveTo(entity)) {
            return;
        }
        AABB aabb = state.getShape((BlockGetter)level, pos).bounds().move(pos);
        if (aabb.intersects(entity.getBoundingBox())) {
            level.removeBlock(pos, false);
            int r = (Integer)state.getValue((Property)AGE) - 1;
            if (r <= 0) {
                return;
            }
            ExplosionHandler.explode((BaseExplosion)new BaseExplosion(new BaseExplosionContext(level, (double)pos.getX() + 0.5, aabb.maxY, (double)pos.getZ() + 0.5, (float)r), new VanillaExplosionContext(null, null, (ExplosionDamageCalculator)new PopFruitCalculator(), false, Explosion.BlockInteraction.KEEP), e -> e instanceof LivingEntity, ParticleExplosionContext.of((float)r)));
            this.onExplode(level, pos, r);
        }
    }

    protected boolean onExplosionAffecting(Entity entity) {
        return entity instanceof LivingEntity;
    }

    protected void onExplode(Level level, BlockPos pos, int r) {
    }

    public MapCodec<AbstractPopFruit> codec() {
        return CODEC;
    }

    protected ItemLike getBaseSeedId() {
        return this.asItem();
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[this.getAge(state)];
    }

    protected int getBonemealAgeIncrease(Level level) {
        return level.getRandom().nextDouble() < GTConfigs.SERVER.popFruitBonemealGrowChance.getAsDouble() ? 1 : 0;
    }

    public void buildState(DataGenContext<Block, ? extends AbstractPopFruit> ctx, RegistrateBlockstateProvider pvd) {
        pvd.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
            int age = (Integer)state.getValue((Property)AGE);
            String id = ctx.getName() + "_" + age;
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().withExistingParent(id, pvd.modLoc("custom/crop/" + id))).texture("all", "block/crop/" + id)).texture("particle", "block/crop/" + ctx.getName() + "_particle")).renderType("cutout")).build();
        });
    }

    public void builtLoot(RegistrateBlockLootTables pvd, AbstractPopFruit block) {
        LootHelper helper = new LootHelper(pvd);
        pvd.add((Block)block, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block.asItem()).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))).when(helper.intState((Block)block, (Property)AGE, 3))).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block.asItem())))));
    }

    private class PopFruitCalculator
    extends ExplosionDamageCalculator {
        private PopFruitCalculator() {
        }

        public boolean shouldDamageEntity(Explosion exp, Entity e) {
            return AbstractPopFruit.this.onExplosionAffecting(e);
        }

        public float getEntityDamageAmount(Explosion exp, Entity e) {
            return super.getEntityDamageAmount(exp, e) * ((Double)GTConfigs.SERVER.popFruitExplosionDamageFactor.get()).floatValue();
        }
    }
}

