/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.block.altar;

import dev.xkmc.glimmeringtales.content.block.altar.BaseRitualBlockEntity;
import dev.xkmc.glimmeringtales.content.block.altar.CoreRitualBlockEntity;
import dev.xkmc.glimmeringtales.content.block.altar.PerformanceConstants;
import dev.xkmc.l2modularblock.tile_api.TickableBlockEntity;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class SideRitualBlockEntity
extends BaseRitualBlockEntity
implements TickableBlockEntity {
    @SerialField
    private BlockPos core = null;

    public SideRitualBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    private void setLink(@Nullable BlockPos pos) {
        this.core = pos;
        this.sync();
        this.setChanged();
    }

    public void tick() {
        CoreRitualBlockEntity be;
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        if (this.level.getGameTime() % 10L != 0L) {
            return;
        }
        if (this.core == null) {
            return;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.core);
        if (blockEntity instanceof CoreRitualBlockEntity && (be = (CoreRitualBlockEntity)blockEntity).isLinked(this, this.getBlockPos())) {
            return;
        }
        this.setLink(null);
    }

    public boolean isLinked(CoreRitualBlockEntity be, BlockPos pos) {
        return this.core != null && this.core.equals((Object)pos);
    }

    @Nullable
    public BlockPos getLink() {
        return this.core;
    }

    public void establishLink(CoreRitualBlockEntity be, BlockPos pos) {
        BlockEntity blockEntity;
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        if (this.core != null && (blockEntity = this.level.getBlockEntity(this.core)) instanceof CoreRitualBlockEntity) {
            CoreRitualBlockEntity old = (CoreRitualBlockEntity)blockEntity;
            old.removeLink(this, pos);
        }
        this.setLink(pos);
    }

    public void removeLink(CoreRitualBlockEntity be, BlockPos pos) {
        if (this.isLinked(be, pos)) {
            this.setLink(null);
        }
    }

    @Override
    public boolean locked() {
        if (this.level == null || this.core == null) {
            return false;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.core);
        if (blockEntity instanceof CoreRitualBlockEntity) {
            CoreRitualBlockEntity be = (CoreRitualBlockEntity)blockEntity;
            return be.locked();
        }
        return false;
    }

    @Override
    public void onReplaced() {
        if (this.level == null || this.level.isClientSide() || this.core == null) {
            return;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.core);
        if (blockEntity instanceof CoreRitualBlockEntity) {
            CoreRitualBlockEntity be = (CoreRitualBlockEntity)blockEntity;
            be.removeLink(this, this.getBlockPos());
        }
    }

    @Override
    public void onPlaced() {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        this.core = null;
        int r = PerformanceConstants.range();
        BlockPos self = this.getBlockPos();
        BlockPos ansPos = null;
        CoreRitualBlockEntity ansBE = null;
        int sqr = Integer.MAX_VALUE;
        for (int x = -r; x <= r; ++x) {
            for (int y = -r; y <= r; ++y) {
                for (int z = -r; z <= r; ++z) {
                    int isqr;
                    CoreRitualBlockEntity be;
                    BlockPos pos = self.offset(x, y, z);
                    BlockEntity blockEntity = this.level.getBlockEntity(pos);
                    if (!(blockEntity instanceof CoreRitualBlockEntity) || (be = (CoreRitualBlockEntity)blockEntity).locked() || (isqr = x * x + y * y + z * z) >= sqr) continue;
                    sqr = isqr;
                    ansPos = pos;
                    ansBE = be;
                }
            }
        }
        if (ansPos != null && ansBE != null) {
            this.setLink(ansPos);
            ansBE.establishLink(this, self);
        }
    }
}

