/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.block.altar;

import dev.xkmc.glimmeringtales.content.block.altar.BaseRitualBlockEntity;
import dev.xkmc.glimmeringtales.content.block.altar.PerformanceConstants;
import dev.xkmc.glimmeringtales.content.block.altar.SideRitualBlockEntity;
import dev.xkmc.l2modularblock.tile_api.TickableBlockEntity;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

@SerialClass
public class CoreRitualBlockEntity
extends BaseRitualBlockEntity
implements TickableBlockEntity {
    @SerialField
    private final LinkedHashSet<BlockPos> linked = new LinkedHashSet();

    public CoreRitualBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tick() {
        this.recheckPos();
    }

    private void recheckPos() {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        if (this.level.getGameTime() % 10L != 0L) {
            return;
        }
        BlockPos pos = this.getBlockPos();
        if (this.linked.removeIf(e -> {
            SideRitualBlockEntity be;
            BlockEntity patt0$temp = this.level.getBlockEntity(e);
            return !(patt0$temp instanceof SideRitualBlockEntity && (be = (SideRitualBlockEntity)patt0$temp).isLinked(this, pos));
        })) {
            this.onLinkBreak();
            this.sync();
            this.setChanged();
        }
    }

    protected List<SideRitualBlockEntity> getLinked() {
        ArrayList<SideRitualBlockEntity> ans = new ArrayList<SideRitualBlockEntity>();
        if (this.level == null) {
            return ans;
        }
        for (BlockPos e : this.linked) {
            BlockEntity blockEntity = this.level.getBlockEntity(e);
            if (!(blockEntity instanceof SideRitualBlockEntity)) continue;
            SideRitualBlockEntity be = (SideRitualBlockEntity)blockEntity;
            ans.add(be);
        }
        return ans;
    }

    public boolean isLinked(SideRitualBlockEntity side, BlockPos pos) {
        return this.linked.contains(pos);
    }

    public void removeLink(SideRitualBlockEntity side, BlockPos pos) {
        if (!this.linked.remove(pos)) {
            return;
        }
        this.onLinkBreak();
        this.sync();
        this.setChanged();
    }

    public void establishLink(SideRitualBlockEntity be, BlockPos pos) {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        this.linked.add(pos);
        this.sync();
        this.setChanged();
    }

    public void onLinkBreak() {
    }

    @Override
    public void onReplaced() {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        for (BlockPos e : this.linked) {
            BlockEntity blockEntity = this.level.getBlockEntity(e);
            if (!(blockEntity instanceof SideRitualBlockEntity)) continue;
            SideRitualBlockEntity be = (SideRitualBlockEntity)blockEntity;
            be.removeLink(this, this.getBlockPos());
        }
    }

    @Override
    public void onPlaced() {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        this.linked.clear();
        int r = PerformanceConstants.range();
        BlockPos self = this.getBlockPos();
        for (int x = -r; x <= r; ++x) {
            for (int y = -r; y <= r; ++y) {
                for (int z = -r; z <= r; ++z) {
                    BlockPos other;
                    SideRitualBlockEntity be;
                    BlockPos pos = self.offset(x, y, z);
                    BlockEntity blockEntity = this.level.getBlockEntity(pos);
                    if (!(blockEntity instanceof SideRitualBlockEntity) || (be = (SideRitualBlockEntity)blockEntity).locked() || (other = be.getLink()) != null && !(other.distSqr((Vec3i)pos) < self.distSqr((Vec3i)pos))) continue;
                    be.establishLink(this, self);
                    this.linked.add(pos);
                }
            }
        }
        this.sync();
        this.setChanged();
    }
}

