/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.compat.golem;

import dev.xkmc.glimmeringtales.content.entity.hostile.MobSpellData;
import dev.xkmc.glimmeringtales.content.entity.hostile.MobSpellHelper;
import dev.xkmc.mob_weapon_api.api.ai.IWeaponHolder;
import dev.xkmc.mob_weapon_api.api.goals.IMeleeGoal;
import dev.xkmc.mob_weapon_api.example.goal.SmartRangedAttackGoal;
import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;

public class GolemSpellGoal<E extends Mob>
extends SmartRangedAttackGoal<E>
implements MobSpellHelper {
    private int useTick = 0;
    private int immobileTime = 0;
    private long nextAttackTimestamp;

    public GolemSpellGoal(E mob, IMeleeGoal melee) {
        this(mob, mob instanceof IWeaponHolder ? (h = (IWeaponHolder)mob) : IWeaponHolder.simple(mob), melee);
        IWeaponHolder h;
    }

    public GolemSpellGoal(E mob, IWeaponHolder holder, IMeleeGoal melee) {
        super(mob, holder, melee, 1.0, 0.0);
    }

    public boolean mayActivate(ItemStack stack) {
        return MobSpellHelper.getSpell((LivingEntity)this.mob, stack) != null && this.nextAttackTimestamp <= this.mob.level().getGameTime();
    }

    public boolean canUse() {
        return super.canUse() && this.getSpell() != null && this.nextAttackTimestamp <= this.mob.level().getGameTime();
    }

    public double range(ItemStack stack) {
        return this.spellRange(this.getSpell());
    }

    public double spellRange(@Nullable MobSpellData spell) {
        double range = spell == null ? 8.0 : spell.mob().idealRange();
        AttributeInstance ins = this.mob.getAttribute(Attributes.FOLLOW_RANGE);
        if (ins != null) {
            range = Math.min(range, ins.getValue());
        }
        return range;
    }

    public void performRangedAttack(LivingEntity target, float v, ItemStack stack, InteractionHand hand) {
    }

    public void start() {
        super.start();
        this.useTick = 0;
    }

    public void stop() {
        MobSpellData spell;
        if (this.useTick > 0 && (spell = this.getSpell()) != null) {
            this.nextAttackTimestamp = this.mob.level().getGameTime() + (long)spell.getCooldown(this.useTick);
        }
        this.useTick = 0;
        if (this.mob.isUsingItem()) {
            this.mob.stopUsingItem();
        }
        super.stop();
    }

    @Override
    public void setUseTick(int tick) {
        this.useTick = tick;
    }

    @Override
    public void setImmobile(int tick) {
        this.immobileTime = tick;
    }

    @Override
    public int modifyDelay(int delay) {
        return 0;
    }

    protected int attack(LivingEntity target, boolean withinRange) {
        return this.attack(this.mob, target, this.useTick, withinRange);
    }

    @Override
    @Nullable
    public MobSpellData getSpell() {
        return MobSpellHelper.getSpell(this.mob, this.holder.getWeaponHand());
    }

    public void tick() {
        MobSpellData spell;
        this.doMelee();
        LivingEntity target = this.mob.getTarget();
        if (this.immobileTime > 0) {
            --this.immobileTime;
            this.mob.getNavigation().stop();
            if (target != null) {
                this.mob.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            }
        } else {
            this.strafing();
        }
        if ((spell = this.getSpell()) == null || target == null) {
            return;
        }
        double dist = this.mob.distanceTo((Entity)target);
        long timestamp = this.mob.level().getGameTime();
        if (this.nextAttackTimestamp <= timestamp) {
            this.nextAttackTimestamp = timestamp + (long)this.attack(target, dist <= this.spellRange(spell) && this.seeTime > 0);
        }
    }
}

