/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.compat.apoth;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.AffixType;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.LootRule;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import dev.shadowsoffire.placebo.util.data.DynamicRegistryProvider;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.Unbreakable;
import org.spongepowered.include.com.google.common.base.Preconditions;

public class RarityProvider
extends DynamicRegistryProvider<LootRarity> {
    public RarityProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(new PackOutput(output.getOutputFolder().resolve("../../../ignored/")), registries, (DynamicRegistry)RarityRegistry.INSTANCE);
    }

    public String getName() {
        return "Rarities";
    }

    public void generate() {
        this.addRarity("common", TextColor.fromRgb((int)0x808080), (Holder<Item>)Apoth.Items.COMMON_MATERIAL, b -> b.sortIndex(300).weights(TieredWeights.builder().with(WorldTier.HAVEN, 600, 0.0f).with(WorldTier.FRONTIER, 290, 0.0f).with(WorldTier.ASCENT, 100, 0.0f).with(WorldTier.SUMMIT, 0, 0.0f).with(WorldTier.PINNACLE, 0, 0.0f)).rule((LootRule)new LootRule.AffixLootRule(AffixType.STAT)).rule((LootRule)new LootRule.ChancedLootRule(0.25f, (LootRule)new LootRule.AffixLootRule(AffixType.STAT))));
        this.addRarity("uncommon", TextColor.fromRgb((int)0x33FF33), (Holder<Item>)Apoth.Items.UNCOMMON_MATERIAL, b -> b.sortIndex(400).weights(TieredWeights.builder().with(WorldTier.HAVEN, 360, 2.5f).with(WorldTier.FRONTIER, 600, 0.0f).with(WorldTier.ASCENT, 300, 0.0f).with(WorldTier.SUMMIT, 120, 0.0f).with(WorldTier.PINNACLE, 0, 0.0f)).rule((LootRule)new LootRule.AffixLootRule(AffixType.STAT)).rule((LootRule)new LootRule.AffixLootRule(AffixType.STAT)).rule((LootRule)new LootRule.ChancedLootRule(0.5f, (LootRule)new LootRule.AffixLootRule(AffixType.BASIC_EFFECT))).rule((LootRule)new LootRule.SocketLootRule(0, 1)));
        this.addRarity("rare", TextColor.fromRgb((int)0x5555FF), (Holder<Item>)Apoth.Items.RARE_MATERIAL, b -> b.sortIndex(500).weights(TieredWeights.builder().with(WorldTier.HAVEN, 40, 5.0f).with(WorldTier.FRONTIER, 100, 5.0f).with(WorldTier.ASCENT, 500, 2.5f).with(WorldTier.SUMMIT, 290, 2.5f).with(WorldTier.PINNACLE, 100, 0.0f)).rule((LootRule)new LootRule.AffixLootRule(AffixType.STAT)).rule((LootRule)new LootRule.AffixLootRule(AffixType.STAT)).rule((LootRule)new LootRule.AffixLootRule(AffixType.BASIC_EFFECT)).rule((LootRule)new LootRule.ChancedLootRule(0.35f, (LootRule)new LootRule.AffixLootRule(AffixType.BASIC_EFFECT))).rule((LootRule)new LootRule.SocketLootRule(0, 2)).rule((LootRule)new LootRule.DurabilityLootRule(0.1f, 0.25f)));
        this.addRarity("epic", TextColor.fromRgb((int)0xBB00BB), (Holder<Item>)Apoth.Items.EPIC_MATERIAL, b -> b.sortIndex(600).weights(TieredWeights.builder().with(WorldTier.HAVEN, 0, 0.0f).with(WorldTier.FRONTIER, 10, 0.0f).with(WorldTier.ASCENT, 100, 5.0f).with(WorldTier.SUMMIT, 540, 5.0f).with(WorldTier.PINNACLE, 650, 2.5f)).rule((LootRule)new LootRule.AffixLootRule(AffixType.STAT)).rule((LootRule)new LootRule.AffixLootRule(AffixType.STAT)).rule((LootRule)new LootRule.AffixLootRule(AffixType.STAT)).rule((LootRule)new LootRule.AffixLootRule(AffixType.BASIC_EFFECT)).rule((LootRule)new LootRule.ChancedLootRule(0.25f, (LootRule)new LootRule.AffixLootRule(AffixType.BASIC_EFFECT))).rule((LootRule)new LootRule.AffixLootRule(AffixType.ABILITY)).rule((LootRule)new LootRule.SocketLootRule(1, 3)).rule((LootRule)new LootRule.DurabilityLootRule(0.25f, 0.55f)));
        this.addRarity("mythic", TextColor.fromRgb((int)15560724), (Holder<Item>)Apoth.Items.MYTHIC_MATERIAL, b -> b.sortIndex(700).weights(TieredWeights.builder().with(WorldTier.HAVEN, 0, 0.0f).with(WorldTier.FRONTIER, 0, 0.0f).with(WorldTier.ASCENT, 0, 0.0f).with(WorldTier.SUMMIT, 50, 5.0f).with(WorldTier.PINNACLE, 250, 10.0f)).rule((LootRule)new LootRule.AffixLootRule(AffixType.STAT)).rule((LootRule)new LootRule.AffixLootRule(AffixType.STAT)).rule((LootRule)new LootRule.AffixLootRule(AffixType.STAT)).rule((LootRule)new LootRule.AffixLootRule(AffixType.STAT)).rule((LootRule)new LootRule.AffixLootRule(AffixType.BASIC_EFFECT)).rule((LootRule)new LootRule.AffixLootRule(AffixType.BASIC_EFFECT)).rule((LootRule)new LootRule.AffixLootRule(AffixType.ABILITY)).rule((LootRule)new LootRule.SelectLootRule(0.95f, (LootRule)new LootRule.SocketLootRule(1, 3), (LootRule)new LootRule.SocketLootRule(4, 4))).rule((LootRule)new LootRule.SelectLootRule(0.99f, (LootRule)new LootRule.DurabilityLootRule(0.45f, 0.75f), (LootRule)new LootRule.ComponentLootRule(DataComponentPatch.builder().set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)).remove(Apoth.Components.DURABILITY_BONUS).build()))));
        this.addRarity("ancient", TextColor.fromRgb((int)15560724), (Holder<Item>)Apoth.Items.BOSS_SUMMONER, b -> b.sortIndex(800).weights(TieredWeights.builder().with(WorldTier.HAVEN, 0, 0.0f).with(WorldTier.FRONTIER, 0, 0.0f).with(WorldTier.ASCENT, 0, 0.0f).with(WorldTier.SUMMIT, 50, 5.0f).with(WorldTier.PINNACLE, 250, 10.0f)).rule((LootRule)new LootRule.AffixLootRule(AffixType.STAT)).rule((LootRule)new LootRule.AffixLootRule(AffixType.STAT)).rule((LootRule)new LootRule.AffixLootRule(AffixType.STAT)).rule((LootRule)new LootRule.AffixLootRule(AffixType.STAT)).rule((LootRule)new LootRule.AffixLootRule(AffixType.BASIC_EFFECT)).rule((LootRule)new LootRule.AffixLootRule(AffixType.BASIC_EFFECT)).rule((LootRule)new LootRule.AffixLootRule(AffixType.ABILITY)).rule((LootRule)new LootRule.SelectLootRule(0.95f, (LootRule)new LootRule.SocketLootRule(1, 3), (LootRule)new LootRule.SocketLootRule(4, 4))).rule((LootRule)new LootRule.SelectLootRule(0.99f, (LootRule)new LootRule.DurabilityLootRule(0.45f, 0.75f), (LootRule)new LootRule.ComponentLootRule(DataComponentPatch.builder().set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)).remove(Apoth.Components.DURABILITY_BONUS).build()))));
    }

    static <T> LootRule componentRule(DataComponentType<T> type, T value) {
        return new LootRule.ComponentLootRule(DataComponentPatch.builder().set(type, value).build());
    }

    void addRarity(String id, TextColor color, Holder<Item> material, UnaryOperator<RarityBuilder> config) {
        this.add(Apotheosis.loc((String)id), (CodecProvider)((RarityBuilder)config.apply(RarityProvider.builder(color, material))).build());
    }

    public static RarityBuilder builder(TextColor color, Holder<Item> material) {
        return new RarityBuilder(color, material);
    }

    public static class RarityBuilder {
        private final TextColor color;
        private final Holder<Item> material;
        private TieredWeights weights;
        private final List<LootRule> rules = new ArrayList<LootRule>();
        private final Map<LootCategory, List<LootRule>> overrides = new IdentityHashMap<LootCategory, List<LootRule>>();
        private int index = 1000;

        public RarityBuilder(TextColor color, Holder<Item> material) {
            this.color = color;
            this.material = material;
        }

        public RarityBuilder weights(TieredWeights.Builder builder) {
            this.weights = builder.build();
            return this;
        }

        public RarityBuilder rule(LootRule rule) {
            this.rules.add(rule);
            return this;
        }

        public RarityBuilder override(LootCategory category, UnaryOperator<RuleListBuilder> config) {
            final ArrayList list = new ArrayList();
            config.apply(new RuleListBuilder(){

                @Override
                public RuleListBuilder rule(LootRule rule) {
                    list.add(rule);
                    return this;
                }
            });
            this.overrides.put(category, list);
            return this;
        }

        public RarityBuilder sortIndex(int index) {
            this.index = index;
            return this;
        }

        public LootRarity build() {
            Preconditions.checkNotNull((Object)this.weights);
            Preconditions.checkArgument((this.rules.size() > 0 ? 1 : 0) != 0);
            return new LootRarity(this.color, this.material, this.weights, this.rules, this.overrides, this.index);
        }
    }

    public static interface RuleListBuilder {
        public RuleListBuilder rule(LootRule var1);
    }
}

