/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.compat.apoth;

import com.tterrag.registrate.providers.RegistrateLangProvider;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixRegistry;
import dev.shadowsoffire.apotheosis.affix.AffixType;
import dev.shadowsoffire.apotheosis.affix.AttributeAffix;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import dev.shadowsoffire.placebo.util.data.DynamicRegistryProvider;
import dev.xkmc.glimmeringtales.compat.apoth.ApothCompat;
import dev.xkmc.glimmeringtales.init.GlimmeringTales;
import dev.xkmc.glimmeringtales.init.reg.GTRegistries;
import dev.xkmc.l2damagetracker.init.L2DamageTracker;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.spongepowered.include.com.google.common.base.Preconditions;

public class GTAffixProvider
extends DynamicRegistryProvider<Affix> {
    public static final List<AffixEntry> LIST = List.of(new AffixEntry("intricate", "of Critical Thinking", (Holder<Attribute>)ALObjects.Attributes.CRIT_CHANCE, AttributeModifier.Operation.ADD_VALUE, 0.1f, 0.2f, 0.3f), new AffixEntry("lacerating", "of Surgical Precision", (Holder<Attribute>)ALObjects.Attributes.CRIT_DAMAGE, AttributeModifier.Operation.ADD_VALUE, 0.1f, 0.2f, 0.3f), new AffixEntry("magical", "of Spell Casting", (Holder<Attribute>)L2DamageTracker.MAGIC_FACTOR, AttributeModifier.Operation.ADD_VALUE, 0.2f, 0.4f, 0.3f), new AffixEntry("sharpened", "of Spike Shooting", (Holder<Attribute>)ALObjects.Attributes.PROJECTILE_DAMAGE, AttributeModifier.Operation.ADD_VALUE, 0.2f, 0.4f, 0.3f), new AffixEntry("fiery", "of Fire Ball", (Holder<Attribute>)L2DamageTracker.FIRE_FACTOR, AttributeModifier.Operation.ADD_VALUE, 0.3f, 0.6f, 0.3f), new AffixEntry("explosive", "of Explosion", (Holder<Attribute>)L2DamageTracker.EXPLOSION_FACTOR, AttributeModifier.Operation.ADD_VALUE, 0.3f, 0.6f, 0.3f), new AffixEntry("freezing", "of Freezing", (Holder<Attribute>)L2DamageTracker.FREEZING_FACTOR, AttributeModifier.Operation.ADD_VALUE, 0.4f, 0.8f, 0.3f), new AffixEntry("thunder", "of Lightning", (Holder<Attribute>)L2DamageTracker.LIGHTNING_FACTOR, AttributeModifier.Operation.ADD_VALUE, 0.4f, 0.8f, 0.3f), new AffixEntry("life_affinity", "of Life Affinity", (Holder<Attribute>)GTRegistries.LIFE.attr(), AttributeModifier.Operation.ADD_VALUE, 0.3f, 0.5f, 0.3f), new AffixEntry("earth_affinity", "of Earth Affinity", (Holder<Attribute>)GTRegistries.EARTH.attr(), AttributeModifier.Operation.ADD_VALUE, 0.3f, 0.5f, 0.3f), new AffixEntry("flame_affinity", "of Flame Affinity", (Holder<Attribute>)GTRegistries.FLAME.attr(), AttributeModifier.Operation.ADD_VALUE, 0.3f, 0.5f, 0.3f), new AffixEntry("snow_affinity", "of Snow Affinity", (Holder<Attribute>)GTRegistries.SNOW.attr(), AttributeModifier.Operation.ADD_VALUE, 0.3f, 0.5f, 0.3f), new AffixEntry("ocean_affinity", "of Ocean Affinity", (Holder<Attribute>)GTRegistries.OCEAN.attr(), AttributeModifier.Operation.ADD_VALUE, 0.3f, 0.5f, 0.3f), new AffixEntry("thunder_affinity", "of Thunder Affinity", (Holder<Attribute>)GTRegistries.THUNDER.attr(), AttributeModifier.Operation.ADD_VALUE, 0.3f, 0.5f, 0.3f));

    public GTAffixProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, (DynamicRegistry)AffixRegistry.INSTANCE);
    }

    public String getName() {
        return "Affixes";
    }

    public void generate() {
        LootRarity common = GTAffixProvider.rarity("common");
        LootRarity uncommon = GTAffixProvider.rarity("uncommon");
        LootRarity rare = GTAffixProvider.rarity("rare");
        LootRarity epic = GTAffixProvider.rarity("epic");
        LootRarity mythic = GTAffixProvider.rarity("mythic");
        for (AffixEntry e : LIST) {
            e.gen(this, common, uncommon, rare, epic, mythic);
        }
        this.futures.add(CompletableFuture.runAsync(() -> ((RarityRegistry)Objects.requireNonNull(RarityRegistry.INSTANCE)).validateExistingHolders()));
        this.futures.add(CompletableFuture.runAsync(() -> ((AffixRegistry)Objects.requireNonNull(AffixRegistry.INSTANCE)).validateExistingHolders()));
    }

    private void addAttribute(String type, String name, Holder<Attribute> attribute, AttributeModifier.Operation op, UnaryOperator<AttributeAffix.Builder> config) {
        AttributeAffix.Builder builder = new AttributeAffix.Builder(attribute, op);
        config.apply(builder);
        this.add(GlimmeringTales.loc(type + "/attribute/" + name), (CodecProvider)builder.build());
    }

    private static LootRarity rarity(String path) {
        return (LootRarity)Preconditions.checkNotNull((Object)((LootRarity)RarityRegistry.INSTANCE.getValue(Apotheosis.loc((String)path))));
    }

    public record AffixEntry(String modid, String type, String id, String desc, Holder<Attribute> attribute, AttributeModifier.Operation op, float min, float max, float slope) {
        public AffixEntry(String id, String desc, Holder<Attribute> attribute, AttributeModifier.Operation op, float min, float max, float slope) {
            this("glimmeringtales", "wand", id, desc, attribute, op, min, max, slope);
        }

        public void genLang(RegistrateLangProvider pvd) {
            pvd.add("affix." + this.modid + ":" + this.type + "/attribute/" + this.id, RegistrateLangProvider.toEnglishName((String)this.id));
            pvd.add("affix." + this.modid + ":" + this.type + "/attribute/" + this.id + ".suffix", this.desc);
        }

        private void gen(GTAffixProvider provider, LootRarity ... rarities) {
            provider.addAttribute(this.type, this.id, this.attribute, this.op, b -> this.build((AttributeAffix.Builder)b, rarities));
        }

        private AttributeAffix.Builder build(AttributeAffix.Builder builder, LootRarity ... rarities) {
            ((AttributeAffix.Builder)builder.definition(AffixType.STAT, 100, 0.0f)).categories(new LootCategory[]{ApothCompat.WAND});
            for (int i = 0; i < rarities.length; ++i) {
                builder.value(rarities[i], this.min * (1.0f + this.slope * (float)i), this.max * (1.0f + this.slope * (float)i));
            }
            return builder;
        }
    }
}

