/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.compat;

import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.crop.ICropProvider;
import com.blakebr0.mysticalagriculture.api.farmland.IEssenceFarmland;
import com.blakebr0.mysticalagriculture.block.InferiumCropBlock;
import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.lib.ModCrops;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import com.blakebr0.mysticalagriculture.tileentity.EssenceVesselTileEntity;
import java.util.Set;
import java.util.function.Function;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.InterModComms;

public class TOPCompat
implements Function<ITheOneProbe, Void> {
    @Override
    public Void apply(ITheOneProbe probe) {
        probe.registerProvider(new IProbeInfoProvider(this){

            public ResourceLocation getID() {
                return MysticalAgriculture.resource("crops");
            }

            public void addProbeInfo(ProbeMode mode, IProbeInfo info, Player player, Level level, BlockState state, IProbeHitData data) {
                EssenceVesselTileEntity vessel;
                ItemStack stack;
                BlockEntity tile;
                Block block = state.getBlock();
                BlockPos pos = data.getPos();
                if (block instanceof ICropProvider) {
                    ResourceKey biome;
                    Set<ResourceLocation> biomes;
                    Block crux;
                    double secondaryChance;
                    Block farmland;
                    ICropProvider provider = (ICropProvider)block;
                    Crop crop = provider.getCrop();
                    Block belowBlock = level.getBlockState(pos.below()).getBlock();
                    info.text((Component)ModTooltips.TIER.args(new Object[]{crop.getTier().getDisplayName()}).build());
                    if (((Boolean)ModConfigs.REQUIRES_EFFECTIVE_FARMLAND.get()).booleanValue() && crop != ModCrops.INFERIUM && (farmland = crop.getTier().getFarmland()) != null) {
                        info.text((Component)ModTooltips.REQUIRES_EFFECTIVE_FARMLAND.args(new Object[]{farmland.getName()}).build());
                    }
                    if (((Boolean)ModConfigs.SECONDARY_SEED_DROPS.get()).booleanValue() && (secondaryChance = crop.getSecondaryChance(belowBlock)) > 0.0) {
                        MutableComponent chanceText = Component.literal((String)String.valueOf((int)(secondaryChance * 100.0))).append("%").withStyle(crop.getTier().getTextColor());
                        info.text((Component)ModTooltips.SECONDARY_CHANCE.args(new Object[]{chanceText}).build());
                    }
                    if ((crux = crop.getCruxBlock()) != null) {
                        ItemStack stack2 = new ItemStack((ItemLike)crux);
                        info.text((Component)ModTooltips.REQUIRES_CRUX.args(new Object[]{stack2.getHoverName()}).build());
                    }
                    if (!(biomes = crop.getRequiredBiomes()).isEmpty() && (biome = level.getBiome(pos).getKey()) != null && !biomes.contains(biome.location())) {
                        info.text((Component)ModTooltips.INVALID_BIOME.color(ChatFormatting.RED).build());
                    }
                    if (block instanceof InferiumCropBlock) {
                        int output = 100;
                        if (belowBlock instanceof IEssenceFarmland) {
                            IEssenceFarmland farmland2 = (IEssenceFarmland)belowBlock;
                            int tier = farmland2.getTier().getValue();
                            output = tier * 50 + 50;
                        }
                        MutableComponent inferiumOutputText = Component.literal((String)String.valueOf(output)).append("%").withStyle(crop.getTier().getTextColor());
                        info.text((Component)ModTooltips.INFERIUM_OUTPUT.args(new Object[]{inferiumOutputText}).build());
                    }
                }
                if (block instanceof IEssenceFarmland) {
                    IEssenceFarmland farmland = (IEssenceFarmland)block;
                    info.text((Component)ModTooltips.TIER.args(new Object[]{farmland.getTier().getDisplayName()}).build());
                }
                if ((tile = level.getBlockEntity(pos)) instanceof EssenceVesselTileEntity && !(stack = (vessel = (EssenceVesselTileEntity)tile).getInventory().getStackInSlot(0)).isEmpty()) {
                    info.text(String.format("%sx %s", stack.getCount(), stack.getHoverName().getString()));
                }
            }
        });
        return null;
    }

    public static void onInterModEnqueue() {
        InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TOPCompat::new);
    }
}

