/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.client.handler;

import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentType;
import com.blakebr0.mysticalagriculture.init.ModItems;
import com.blakebr0.mysticalagriculture.item.AugmentItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;

public final class AugmentTooltipHandler {
    @SubscribeEvent
    public void onGatherComponents(RenderTooltipEvent.GatherComponents event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        Item item = stack.getItem();
        if (item instanceof AugmentItem) {
            AugmentItem item2 = (AugmentItem)item;
            List tooltip = event.getTooltipElements();
            List<ItemStack> stacks = AugmentTooltipHandler.getDisplayItemStacks(item2.getAugment());
            tooltip.add(1, Either.right((Object)new AugmentToolTypesComponent(10 * stacks.size() - 10, 12, stacks)));
        }
    }

    private static List<ItemStack> getDisplayItemStacks(Augment augment) {
        EnumSet<AugmentType> types = augment.getAugmentTypes();
        if (types.contains((Object)AugmentType.TOOL)) {
            return List.of(new ItemStack((ItemLike)Items.DIAMOND_PICKAXE), new ItemStack((ItemLike)Items.DIAMOND_SHOVEL), new ItemStack((ItemLike)Items.DIAMOND_AXE), new ItemStack((ItemLike)Items.DIAMOND_HOE), new ItemStack((ItemLike)Items.SHEARS), new ItemStack((ItemLike)Items.FISHING_ROD), new ItemStack((ItemLike)ModItems.DIAMOND_SICKLE.get()), new ItemStack((ItemLike)ModItems.DIAMOND_SCYTHE.get()));
        }
        if (types.contains((Object)AugmentType.WEAPON)) {
            return List.of(new ItemStack((ItemLike)Items.DIAMOND_SWORD), new ItemStack((ItemLike)Items.BOW), new ItemStack((ItemLike)Items.CROSSBOW), new ItemStack((ItemLike)ModItems.DIAMOND_SICKLE.get()), new ItemStack((ItemLike)ModItems.DIAMOND_SCYTHE.get()));
        }
        if (types.contains((Object)AugmentType.ARMOR)) {
            return List.of(new ItemStack((ItemLike)Items.DIAMOND_HELMET), new ItemStack((ItemLike)Items.DIAMOND_CHESTPLATE), new ItemStack((ItemLike)Items.DIAMOND_LEGGINGS), new ItemStack((ItemLike)Items.DIAMOND_BOOTS));
        }
        return types.stream().map(AugmentTooltipHandler::getDisplayItemStackForAugmentType).filter(s -> !s.isEmpty()).toList();
    }

    private static ItemStack getDisplayItemStackForAugmentType(AugmentType type) {
        Item item = switch (type) {
            default -> throw new MatchException(null, null);
            case AugmentType.TOOL, AugmentType.WEAPON, AugmentType.ARMOR, AugmentType.STAFF -> null;
            case AugmentType.SWORD -> Items.DIAMOND_SWORD;
            case AugmentType.PICKAXE -> Items.DIAMOND_PICKAXE;
            case AugmentType.SHOVEL -> Items.DIAMOND_SHOVEL;
            case AugmentType.AXE -> Items.DIAMOND_AXE;
            case AugmentType.HOE -> Items.DIAMOND_HOE;
            case AugmentType.BOW -> Items.BOW;
            case AugmentType.CROSSBOW -> Items.CROSSBOW;
            case AugmentType.SHEARS -> Items.SHEARS;
            case AugmentType.FISHING_ROD -> Items.FISHING_ROD;
            case AugmentType.SICKLE -> (Item)ModItems.DIAMOND_SICKLE.get();
            case AugmentType.SCYTHE -> (Item)ModItems.DIAMOND_SCYTHE.get();
            case AugmentType.HELMET -> Items.DIAMOND_HELMET;
            case AugmentType.CHESTPLATE -> Items.DIAMOND_CHESTPLATE;
            case AugmentType.LEGGINGS -> Items.DIAMOND_LEGGINGS;
            case AugmentType.BOOTS -> Items.DIAMOND_BOOTS;
        };
        return item == null ? ItemStack.EMPTY : new ItemStack((ItemLike)item);
    }

    public record AugmentToolTypesComponent(int width, int height, List<ItemStack> stacks) implements ClientTooltipComponent,
    TooltipComponent
    {
        public void renderImage(Font font, int tooltipX, int tooltipY, GuiGraphics gfx) {
            PoseStack matrix = gfx.pose();
            matrix.pushPose();
            matrix.translate((float)tooltipX, (float)tooltipY, 0.0f);
            matrix.scale(0.5f, 0.5f, 1.0f);
            int drawn = 0;
            for (ItemStack stack : this.stacks) {
                gfx.renderItem(stack, drawn % 10 * 18, 0);
                ++drawn;
            }
            matrix.popPose();
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth(Font font) {
            return this.width;
        }
    }
}

