/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.gate.endless;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.gateways.gate.Reward;
import dev.shadowsoffire.gateways.gate.WaveEntity;
import dev.shadowsoffire.gateways.gate.WaveModifier;
import dev.shadowsoffire.gateways.gate.endless.ApplicationMode;
import java.util.Collections;
import java.util.List;

public record EndlessModifier(ApplicationMode appMode, List<WaveEntity> entities, List<Reward> rewards, List<WaveModifier> modifiers, int waveTime, int setupTime) {
    public static Codec<EndlessModifier> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ApplicationMode.CODEC.fieldOf("application_mode").forGetter(EndlessModifier::appMode), (App)WaveEntity.CODEC.listOf().optionalFieldOf("entities", Collections.emptyList()).forGetter(EndlessModifier::entities), (App)Reward.CODEC.listOf().optionalFieldOf("rewards", Collections.emptyList()).forGetter(EndlessModifier::rewards), (App)WaveModifier.CODEC.listOf().optionalFieldOf("modifiers", Collections.emptyList()).forGetter(EndlessModifier::modifiers), (App)Codec.INT.optionalFieldOf("max_wave_time", (Object)0).forGetter(EndlessModifier::waveTime), (App)Codec.INT.optionalFieldOf("setup_time", (Object)0).forGetter(EndlessModifier::setupTime)).apply((Applicative)inst, EndlessModifier::new));

    public EndlessModifier(ApplicationMode appMode, List<WaveEntity> entities, List<Reward> rewards, List<WaveModifier> modifiers, int waveTime, int setupTime) {
        this.appMode = appMode;
        this.entities = entities;
        this.rewards = rewards;
        this.modifiers = modifiers;
        this.waveTime = waveTime;
        this.setupTime = setupTime;
        Preconditions.checkArgument((!this.entities.isEmpty() || !this.rewards.isEmpty() || !this.modifiers.isEmpty() ? 1 : 0) != 0, (Object)"An Endless Modifier must provide at least one of entities, rewards, or modifiers.");
    }
}

