/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.apothic_attributes.api.AttributeHelper;
import dev.shadowsoffire.gateways.client.GatewaysClient;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.entity.NormalGatewayEntity;
import dev.shadowsoffire.gateways.gate.Failure;
import dev.shadowsoffire.gateways.gate.Reward;
import dev.shadowsoffire.gateways.gate.Wave;
import dev.shadowsoffire.gateways.gate.WaveEntity;
import dev.shadowsoffire.gateways.gate.WaveModifier;
import dev.shadowsoffire.gateways.gate.normal.NormalGateway;
import dev.shadowsoffire.placebo.PlaceboClient;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;

public class NormalGateClient {
    public static void appendPearlTooltip(NormalGateway gate, Item.TooltipContext ctx, List<Component> tooltips, TooltipFlag flag) {
        List<Reward> rewards;
        List<MutableComponent> list;
        MutableComponent comp;
        int waveIdx = PlaceboClient.getTooltipScrollIndex((int)gate.getNumWaves());
        Wave wave = gate.getWave(waveIdx);
        if (Screen.hasShiftDown()) {
            comp = Component.translatable((String)"tooltip.gateways.wave", (Object[])new Object[]{waveIdx + 1, gate.getNumWaves()}).withStyle(ChatFormatting.GRAY);
            comp.append(CommonComponents.SPACE);
            comp.append((Component)Component.translatable((String)"tooltip.gateways.scroll").withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY).withUnderlined(Boolean.valueOf(false))));
            tooltips.add((Component)comp);
            comp = AttributeHelper.list().append((Component)Component.translatable((String)"tooltip.gateways.entities").withStyle(Style.EMPTY.withColor(8900331)));
            tooltips.add((Component)comp);
            for (WaveEntity waveEntity : wave.entities()) {
                comp = AttributeHelper.list().append((Component)Component.translatable((String)"tooltip.gateways.dot", (Object[])new Object[]{waveEntity.getDescription()}).withStyle(Style.EMPTY.withColor(8900331)));
                tooltips.add((Component)comp);
            }
            if (!wave.modifiers().isEmpty()) {
                comp = AttributeHelper.list().append((Component)Component.translatable((String)"tooltip.gateways.modifiers").withStyle(ChatFormatting.RED));
                tooltips.add((Component)comp);
                for (WaveModifier waveModifier : wave.modifiers()) {
                    waveModifier.appendHoverText(ctx, c -> tooltips.add((Component)AttributeHelper.list().append((Component)Component.translatable((String)"tooltip.gateways.dot", (Object[])new Object[]{c.withStyle(ChatFormatting.RED)}).withStyle(s -> s.withColor(ChatFormatting.RED)))));
                }
            }
            comp = AttributeHelper.list().append((Component)Component.translatable((String)"tooltip.gateways.rewards").withStyle(s -> s.withColor(ChatFormatting.GOLD)));
            tooltips.add((Component)comp);
            for (Reward reward : wave.rewards()) {
                reward.appendHoverText(ctx, c -> tooltips.add((Component)AttributeHelper.list().append((Component)Component.translatable((String)"tooltip.gateways.dot", (Object[])new Object[]{c}).withStyle(s -> s.withColor(ChatFormatting.GOLD)))));
            }
        } else {
            comp = Component.translatable((String)("tooltip.gateways.num_wave" + (gate.getNumWaves() == 1 ? "" : "s")), (Object[])new Object[]{gate.getNumWaves()}).withStyle(ChatFormatting.GRAY);
            comp.append(CommonComponents.SPACE);
            comp.append((Component)Component.translatable((String)"tooltip.gateways.shift").withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY)));
            tooltips.add((Component)comp);
        }
        List<Failure> failures = gate.failures();
        if (!failures.isEmpty()) {
            if (Screen.hasControlDown()) {
                comp = Component.translatable((String)"tooltip.gateways.failures").withStyle(Style.EMPTY.withColor(ChatFormatting.RED));
                tooltips.add((Component)comp);
                for (Failure f : failures) {
                    f.appendHoverText(ctx, c -> tooltips.add((Component)AttributeHelper.list().append((Component)c.withStyle(Style.EMPTY.withColor(ChatFormatting.RED)))));
                }
            } else {
                comp = Component.translatable((String)("tooltip.gateways.num_failure" + (failures.size() == 1 ? "" : "s")), (Object[])new Object[]{failures.size()}).withStyle(Style.EMPTY.withColor(ChatFormatting.RED));
                comp.append(CommonComponents.SPACE);
                comp.append((Component)Component.translatable((String)"tooltip.gateways.ctrl").withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY)));
                tooltips.add((Component)comp);
            }
        }
        if (!(list = gate.rules().buildDeviations()).isEmpty()) {
            if (Screen.hasAltDown()) {
                comp = Component.translatable((String)"tooltip.gateways.rules", (Object[])new Object[]{list.size()}).withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GREEN));
                tooltips.add((Component)comp);
                list.forEach(c -> tooltips.add((Component)AttributeHelper.list().append((Component)c.withStyle(ChatFormatting.DARK_GREEN))));
            } else {
                comp = Component.translatable((String)("tooltip.gateways.num_rule" + (list.size() == 1 ? "" : "s")), (Object[])new Object[]{list.size()}).withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GREEN));
                comp.append(CommonComponents.SPACE);
                comp.append((Component)Component.translatable((String)"tooltip.gateways.alt").withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY)));
                tooltips.add((Component)comp);
            }
        }
        if (!(rewards = gate.rewards()).isEmpty()) {
            comp = Component.translatable((String)"tooltip.gateways.key_rewards").withStyle(Style.EMPTY.withColor(3385888));
            tooltips.add((Component)comp);
            for (Reward r : rewards) {
                r.appendHoverText(ctx, c -> tooltips.add((Component)AttributeHelper.list().append((Component)c.withStyle(Style.EMPTY.withColor(3385888)))));
            }
        }
    }

    public static void renderBossBar(GatewayEntity gateEntity, Object guiGfx, int x, int y, boolean isInWorld) {
        int i;
        NormalGatewayEntity gate = (NormalGatewayEntity)gateEntity;
        GuiGraphics gfx = (GuiGraphics)guiGfx;
        PoseStack pose = gfx.pose();
        int color = gate.getGateway().color().getValue();
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        RenderSystem.setShaderColor((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)1.0f);
        int wave = gate.getWave() + 1;
        int maxWave = gate.getGateway().getNumWaves();
        int enemies = gate.getActiveEnemies();
        int maxEnemies = gate.getCurrentWave().entities().stream().mapToInt(WaveEntity::getCount).sum();
        Objects.requireNonNull(Minecraft.getInstance().font);
        int y2 = y + 10 + 9;
        pose.pushPose();
        pose.translate(0.0, 0.0, -0.01);
        gfx.blitSprite(GatewaysClient.WHITE_BACKGROUND, x, y, 182, 5);
        gfx.blitSprite(GatewaysClient.WHITE_BACKGROUND, x, y2, 182, 5);
        pose.popPose();
        float waveProgress = 1.0f / (float)maxWave;
        float progress = waveProgress * (float)(maxWave - wave + 1);
        if (gate.isWaveActive()) {
            progress -= waveProgress * ((float)(maxEnemies - enemies) / (float)maxEnemies);
        }
        if ((i = (int)(progress * 183.0f)) > 0) {
            gfx.blitSprite(GatewaysClient.WHITE_PROGRESS, 182, 5, 0, 0, x, y, i, 5);
        }
        float maxTime = gate.getMaxWaveTime();
        if (gate.isWaveActive()) {
            i = (int)((maxTime - (float)gate.getTicksActive()) / maxTime * 183.0f);
            if (i > 0) {
                gfx.blitSprite(GatewaysClient.WHITE_PROGRESS, 182, 5, 0, 0, x, y2, i, 5);
            }
        } else {
            maxTime = gate.getSetupTime();
            i = (int)((float)gate.getTicksActive() / maxTime * 183.0f);
            if (i > 0) {
                gfx.blitSprite(GatewaysClient.WHITE_PROGRESS, 182, 5, 0, 0, x, y2, i, 5);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Font font = Minecraft.getInstance().font;
        MutableComponent component = Component.literal((String)gate.getCustomName().getString()).withStyle(ChatFormatting.GOLD);
        int strWidth = font.width((FormattedText)component);
        int textX = x + 91 - strWidth / 2;
        int textY = y - 9;
        if (isInWorld) {
            GatewaysClient.drawReversedDropShadow(gfx, font, (Component)component, textX, textY);
        } else {
            gfx.drawString(font, (Component)component, textX, textY, 0xFFFFFF, true);
        }
        textY = y2 - 9;
        int time = (int)maxTime - gate.getTicksActive();
        float tps = gateEntity.level().tickRateManager().tickrate();
        String str = I18n.get((String)"boss.gateways.wave", (Object[])new Object[]{wave, maxWave, StringUtil.formatTickDuration((int)time, (float)tps), enemies});
        if (!gate.isWaveActive()) {
            str = gate.isLastWave() ? I18n.get((String)"boss.gateways.done", (Object[])new Object[0]) : I18n.get((String)"boss.gateways.starting", (Object[])new Object[]{wave, StringUtil.formatTickDuration((int)time, (float)tps)});
        }
        component = Component.literal((String)str).withStyle(ChatFormatting.GREEN);
        strWidth = font.width((FormattedText)component);
        textX = x + 91 - strWidth / 2;
        if (isInWorld) {
            GatewaysClient.drawReversedDropShadow(gfx, font, (Component)component, textX, textY);
        } else {
            gfx.drawString(font, (Component)component, textX, textY, 0xFFFFFF, true);
        }
    }
}

