/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways;

import dev.shadowsoffire.gateways.GatewayEvents;
import dev.shadowsoffire.gateways.GatewayObjects;
import dev.shadowsoffire.gateways.data.GatewayProvider;
import dev.shadowsoffire.gateways.gate.Failure;
import dev.shadowsoffire.gateways.gate.GatewayRegistry;
import dev.shadowsoffire.gateways.gate.Reward;
import dev.shadowsoffire.gateways.gate.WaveEntity;
import dev.shadowsoffire.gateways.gate.WaveModifier;
import dev.shadowsoffire.gateways.gate.endless.ApplicationMode;
import dev.shadowsoffire.gateways.payloads.ParticlePayload;
import dev.shadowsoffire.placebo.datagen.DataGenBuilder;
import dev.shadowsoffire.placebo.network.PayloadHelper;
import dev.shadowsoffire.placebo.network.PayloadProvider;
import dev.shadowsoffire.placebo.tabs.TabFillingRegistry;
import net.minecraft.core.Holder;
import net.minecraft.data.DataProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.Stats;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="gateways")
public class Gateways {
    public static final String MODID = "gateways";
    public static final Logger LOGGER = LogManager.getLogger((String)"Gateways to Eternity");

    public Gateways(IEventBus bus) {
        bus.register((Object)this);
        PayloadHelper.registerPayload((PayloadProvider)new ParticlePayload.Provider());
        NeoForge.EVENT_BUS.register((Object)new GatewayEvents());
        GatewayObjects.bootstrap(bus);
        WaveModifier.initCodecs();
        Reward.initCodecs();
        WaveEntity.initCodecs();
        Failure.initCodecs();
        ApplicationMode.initCodecs();
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        GatewayRegistry.INSTANCE.registerToBus();
        e.enqueueWork(() -> {
            TabFillingRegistry.register((ResourceKey)GatewayObjects.TAB.getKey(), (Holder[])new Holder[]{GatewayObjects.GATE_PEARL});
            Stats.CUSTOM.get((Object)GatewayObjects.GATES_DEFEATED, StatFormatter.DEFAULT);
        });
    }

    @SubscribeEvent
    public void data(GatherDataEvent e) {
        DataProvider.INDENT_WIDTH.set(4);
        DataGenBuilder.create((String[])new String[]{MODID}).provider(GatewayProvider::new).build(e);
    }

    public static ResourceLocation loc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public static MutableComponent lang(String type, String path, Object ... args) {
        return Component.translatable((String)Gateways.langKey(type, path), (Object[])args);
    }

    public static String langKey(String type, String path) {
        return type + ".gateways." + path;
    }
}

