/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.utils;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RaycastUtils {
    public static HitResult raycast(Entity entity, float dst, float pPartialTick) {
        return RaycastUtils.raycastRotated(entity, Vec3.ZERO, dst, pPartialTick);
    }

    public static HitResult pick(Entity entity, Vec3 offset, double pHitDistance, float pPartialTicks, boolean pHitFluids) {
        Vec3 vec3 = entity.getEyePosition(pPartialTicks);
        Vec3 vec31 = entity.calculateViewVector(entity.getXRot(), entity.getYRot()).xRot((float)offset.x).yRot((float)offset.y).zRot((float)offset.z);
        Vec3 vec32 = vec3.add(vec31.x * pHitDistance, vec31.y * pHitDistance, vec31.z * pHitDistance);
        return entity.level().clip(new ClipContext(vec3, vec32, ClipContext.Block.OUTLINE, pHitFluids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, entity));
    }

    public static HitResult pick(Entity entity, Vec3 pos, Vec3 offset, double pHitDistance, float pPartialTicks, boolean pHitFluids) {
        Vec3 vec3 = pos;
        Vec3 vec31 = entity.calculateViewVector(entity.getXRot(), entity.getYRot()).xRot((float)offset.x).yRot((float)offset.y).zRot((float)offset.z);
        Vec3 vec32 = vec3.add(vec31.x * pHitDistance, vec31.y * pHitDistance, vec31.z * pHitDistance);
        return entity.level().clip(new ClipContext(vec3, vec32, ClipContext.Block.OUTLINE, pHitFluids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, entity));
    }

    public static HitResult raycastRotated(Entity pEntity, Vec3 offset, float dst, float pPartialTick) {
        AABB aabb;
        double actualDist = dst;
        double distanceSqrd = Mth.square((double)actualDist);
        Vec3 eyePosition = pEntity.getEyePosition(pPartialTick);
        HitResult hitresult = RaycastUtils.pick(pEntity, offset, actualDist, pPartialTick, false);
        double hitDistance = hitresult.getLocation().distanceToSqr(eyePosition);
        if (hitresult.getType() != HitResult.Type.MISS) {
            distanceSqrd = hitDistance;
            actualDist = Math.sqrt(hitDistance);
        }
        Vec3 viewVector = pEntity.getViewVector(pPartialTick);
        Vec3 increment = eyePosition.add(viewVector.x * actualDist, viewVector.y * actualDist, viewVector.z * actualDist);
        EntityHitResult entityhitresult = ProjectileUtil.getEntityHitResult((Entity)pEntity, (Vec3)eyePosition, (Vec3)increment, (AABB)(aabb = pEntity.getBoundingBox().expandTowards(viewVector.scale(actualDist)).inflate(1.0, 1.0, 1.0)), targeted -> !targeted.isSpectator() && targeted.isPickable(), (double)distanceSqrd);
        return entityhitresult != null && entityhitresult.getLocation().distanceToSqr(eyePosition) < hitDistance ? RaycastUtils.filterHitResult((HitResult)entityhitresult, eyePosition, dst) : RaycastUtils.filterHitResult(hitresult, eyePosition, dst);
    }

    public static HitResult raycastRotatedAtPos(Entity pEntity, Vec3 pos, Vec3 offset, float dst, float pPartialTick) {
        AABB aabb;
        double actualDist = dst;
        double distanceSqrd = Mth.square((double)actualDist);
        Vec3 eyePosition = pos;
        HitResult hitresult = RaycastUtils.pick(pEntity, pos, offset, actualDist, pPartialTick, false);
        double hitDistance = hitresult.getLocation().distanceToSqr(eyePosition);
        if (hitresult.getType() != HitResult.Type.MISS) {
            distanceSqrd = hitDistance;
            actualDist = Math.sqrt(hitDistance);
        }
        Vec3 viewVector = pEntity.calculateViewVector(pEntity.getXRot(), pEntity.getYRot());
        Vec3 increment = eyePosition.add(viewVector.x * actualDist, viewVector.y * actualDist, viewVector.z * actualDist);
        EntityHitResult entityhitresult = ProjectileUtil.getEntityHitResult((Entity)pEntity, (Vec3)eyePosition, (Vec3)increment, (AABB)(aabb = pEntity.getBoundingBox().expandTowards(viewVector.scale(actualDist)).inflate(1.0, 1.0, 1.0)), targeted -> !targeted.isSpectator() && targeted.isPickable(), (double)distanceSqrd);
        return entityhitresult != null && entityhitresult.getLocation().distanceToSqr(eyePosition) < hitDistance ? RaycastUtils.filterHitResult((HitResult)entityhitresult, eyePosition, dst) : RaycastUtils.filterHitResult(hitresult, eyePosition, dst);
    }

    private static HitResult filterHitResult(HitResult pHitResult, Vec3 pPos, double pBlockInteractionRange) {
        Vec3 vec3 = pHitResult.getLocation();
        if (!vec3.closerThan((Position)pPos, pBlockInteractionRange)) {
            Vec3 vec31 = pHitResult.getLocation();
            Direction direction = Direction.getNearest((double)(vec31.x - pPos.x), (double)(vec31.y - pPos.y), (double)(vec31.z - pPos.z));
            return BlockHitResult.miss((Vec3)vec31, (Direction)direction, (BlockPos)BlockPos.containing((Position)vec31));
        }
        return pHitResult;
    }
}

