/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.utils;

import com.hakimen.wandrous.common.item.component.SpellCastsDataComponent;
import com.hakimen.wandrous.common.registers.DataComponentsRegister;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;

public class ChargesUtils {
    public static boolean hasCharge(ItemStack stack) {
        return stack.has((DataComponentType)DataComponentsRegister.CHARGES_COMPONENT.get());
    }

    public static int maxCharges(ItemStack stack) {
        return ((SpellCastsDataComponent.SpellCastsData)stack.get((DataComponentType)DataComponentsRegister.CHARGES_COMPONENT.get())).getMaxCasts();
    }

    public static int currentCharges(ItemStack stack) {
        return ((SpellCastsDataComponent.SpellCastsData)stack.get((DataComponentType)DataComponentsRegister.CHARGES_COMPONENT.get())).getRemaining();
    }

    public static void loseCharge(ItemStack stack) {
        stack.update((DataComponentType)DataComponentsRegister.CHARGES_COMPONENT.get(), (Object)SpellCastsDataComponent.DEFAULT, spellCastsData -> new SpellCastsDataComponent.SpellCastsDataBuilder((SpellCastsDataComponent.SpellCastsData)spellCastsData).setRemaining(Math.max(0, spellCastsData.getRemaining() - 1)).build());
    }

    public static boolean hasSpentCharges(ItemStack stack) {
        return ChargesUtils.maxCharges(stack) != ChargesUtils.currentCharges(stack);
    }

    public static void regainCharges(ItemStack stack, int amount) {
        stack.update((DataComponentType)DataComponentsRegister.CHARGES_COMPONENT.get(), (Object)SpellCastsDataComponent.DEFAULT, spellCastsData -> new SpellCastsDataComponent.SpellCastsDataBuilder((SpellCastsDataComponent.SpellCastsData)spellCastsData).setRemaining(Math.max(0, spellCastsData.getRemaining() + amount)).build());
    }

    public static void regainAllCharges(ItemStack stack) {
        stack.update((DataComponentType)DataComponentsRegister.CHARGES_COMPONENT.get(), (Object)SpellCastsDataComponent.DEFAULT, spellCastsData -> new SpellCastsDataComponent.SpellCastsDataBuilder((SpellCastsDataComponent.SpellCastsData)spellCastsData).setRemaining(spellCastsData.getMaxCasts()).build());
    }
}

