/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.spell.mover;

import com.hakimen.wandrous.common.entity.projectiles.SpellCastingProjectile;
import com.hakimen.wandrous.common.spell.SpellContext;
import com.hakimen.wandrous.common.spell.mover.ISpellMover;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class HomingMover
implements ISpellMover {
    @Override
    public void move(SpellContext context, SpellCastingProjectile projectile) {
        if (projectile.tickCount > 2) {
            if (context.getHomingTarget() == null) {
                Level level = context.getLevel();
                Vec3 pos = projectile.getEyePosition();
                LivingEntity target = context.isCanHitCaster() ? null : (LivingEntity)context.getOriginalCaster();
                LivingEntity closest = level.getNearestEntity(LivingEntity.class, TargetingConditions.DEFAULT, target, pos.x, pos.y, pos.z, AABB.ofSize((Vec3)pos, (double)32.0, (double)32.0, (double)32.0));
                if (closest != null) {
                    context.setHomingTarget(closest);
                }
            } else if (context.getHomingTarget() != null) {
                LivingEntity target = context.getHomingTarget();
                if (target.getHealth() > 0.0f) {
                    projectile.setNoGravity(true);
                    projectile.setDeltaMovement(target.getPosition(0.0f).subtract(projectile.getPosition(0.0f).subtract(0.0, (double)(target.getBbHeight() / 2.0f), 0.0)).normalize().scale(Math.clamp(target.getPosition(0.0f).distanceTo(projectile.getPosition(0.0f)) / 4.0, 0.0, context.getStatus().getSpeed() > 0.0f ? (double)context.getStatus().getSpeed() : (double)0.1f)));
                } else {
                    context.setHomingTarget(null);
                    projectile.setNoGravity(false);
                }
            }
        }
    }
}

