/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.spell.effects.spells.teleports;

import com.hakimen.wandrous.common.spell.SpellContext;
import com.hakimen.wandrous.common.spell.SpellEffect;
import com.hakimen.wandrous.common.spell.SpellStatus;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SwapTeleportEffect
extends SpellEffect {
    public SwapTeleportEffect() {
        this.setKind(8);
        this.setStatus(new SpellStatus().setManaDrain(50));
    }

    @Override
    public void cast(SpellContext context) {
        context.mergeStatus(this.getStatus());
        if (!context.getHit().isEmpty()) {
            Entity hit = (Entity)context.getHit().get(context.getHit().size() - 1);
            Vec3 swapPos = context.getOriginalCaster().getPosition(0.0f);
            Vec3 hitPos = hit.getPosition(0.0f);
            context.getOriginalCaster().teleportTo(hitPos.x, hitPos.y, hitPos.z);
            Level level = context.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                level2.sendParticles((ParticleOptions)ParticleTypes.PORTAL, hitPos.x, hitPos.y + 1.0, hitPos.z, 20, 1.0, 1.0, 1.0, 0.0);
            }
            hit.teleportTo(swapPos.x, swapPos.y, swapPos.z);
        }
    }
}

