/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.spell.effects.spells.teleports;

import com.hakimen.wandrous.common.spell.SpellContext;
import com.hakimen.wandrous.common.spell.SpellEffect;
import com.hakimen.wandrous.common.spell.SpellStatus;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class HomebringerTeleportEffect
extends SpellEffect {
    public HomebringerTeleportEffect() {
        this.setKind(8);
        this.setStatus(new SpellStatus().setManaDrain(50));
    }

    @Override
    public void cast(SpellContext context) {
        context.mergeStatus(this.getStatus());
        if (!context.getHit().isEmpty()) {
            Entity hit = (Entity)context.getHit().get(context.getHit().size() - 1);
            Vec3 location = hit.getPosition(0.0f);
            Vec3 originalCasterLocation = context.getOriginalCaster().getPosition(0.0f);
            Vec3 offset = originalCasterLocation.subtract(location).normalize();
            Level level = context.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                level2.sendParticles((ParticleOptions)ParticleTypes.PORTAL, location.x, location.y + 1.0, location.z, 20, 1.0, 1.0, 1.0, 0.0);
            }
            hit.teleportTo(originalCasterLocation.x - offset.x, originalCasterLocation.y - offset.y, originalCasterLocation.z - offset.z);
        }
    }
}

