/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.spell.effects.spells.summon_spells;

import com.hakimen.wandrous.common.spell.SpellContext;
import com.hakimen.wandrous.common.spell.SpellEffect;
import com.hakimen.wandrous.common.spell.SpellStatus;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SummonBlockEffect
extends SpellEffect {
    BlockState block;

    public SummonBlockEffect(BlockState block, int cost) {
        this.setKind(8);
        this.block = block;
        this.setStatus(new SpellStatus().setManaDrain(cost));
    }

    @Override
    public void cast(SpellContext context) {
        context.mergeStatus(this.getStatus());
        Entity caster = context.getCaster();
        Level level = context.getLevel();
        Vec3 location = context.getLocation();
        BlockPos pos = new BlockPos((int)location.x, (int)location.y, (int)location.z);
        if (caster != null) {
            BlockPos newPos;
            LivingEntity entity;
            BlockPos newPos2;
            if (caster instanceof LivingEntity && this.placeBlockIfReplaceable(level, newPos2 = (entity = (LivingEntity)caster).getOnPos().below(), context)) {
                return;
            }
            if (!context.isCastPositionModified() && this.placeBlockIfReplaceable(level, newPos = caster.getOnPos(), context)) {
                return;
            }
            if (this.placeBlockIfReplaceable(level, pos, context)) {
                return;
            }
            for (Direction dir : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST, Direction.UP, Direction.DOWN}) {
                if (!this.placeBlockIfReplaceable(level, pos.relative(dir), context)) continue;
                return;
            }
        }
    }

    protected boolean placeBlockIfReplaceable(Level level, BlockPos pos, SpellContext context) {
        SoundType sound = this.block.getBlock().getSoundType(this.block, (LevelReader)level, pos, null);
        if (level.getBlockState(pos).canBeReplaced()) {
            level.setBlockAndUpdate(pos, this.block);
            level.playSound(null, pos, sound.getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }
}

