/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.spell.effects.spells.static_projectiles.utility;

import com.hakimen.wandrous.common.spell.SpellContext;
import com.hakimen.wandrous.common.spell.SpellEffect;
import com.hakimen.wandrous.common.spell.SpellStatus;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SmeltSpellEffect
extends SpellEffect {
    public SmeltSpellEffect() {
        this.setKind(8);
        this.setStatus(new SpellStatus().setManaDrain(40).setRadius(2.0f));
    }

    @Override
    public void cast(SpellContext context) {
        context.mergeStatus(this.getStatus());
        Level level = context.getLevel();
        float radius = context.getStatus().getRadius();
        AABB aabb = AABB.ofSize((Vec3)context.getLocation(), (double)radius, (double)radius, (double)radius);
        List items = level.getEntitiesOfClass(ItemEntity.class, aabb);
        for (ItemEntity item : items) {
            Optional recipeOptional = level.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(item.getItem()), level);
            if (!recipeOptional.isPresent()) continue;
            RecipeHolder smeltingRecipeRecipeHolder = (RecipeHolder)recipeOptional.get();
            ItemStack stack = ((SmeltingRecipe)smeltingRecipeRecipeHolder.value()).getResultItem((HolderLookup.Provider)level.registryAccess());
            item.getItem().shrink(1);
            double x = item.getPosition((float)0.0f).x;
            double y = item.getPosition((float)0.0f).y;
            double z = item.getPosition((float)0.0f).z;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.FLAME, x, y, z, 10, 0.1 * (double)radius, 0.1 * (double)radius, 0.1 * (double)radius, (double)0.01f);
            }
            level.addFreshEntity((Entity)new ItemEntity(level, x, y, z, stack.copyWithCount(1)));
            level.addFreshEntity((Entity)new ExperienceOrb(level, x, y, z, (int)((SmeltingRecipe)smeltingRecipeRecipeHolder.value()).getExperience()));
            break;
        }
    }
}

