/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.spell.effects.spells.static_projectiles.utility;

import com.hakimen.wandrous.common.spell.SpellContext;
import com.hakimen.wandrous.common.spell.SpellEffect;
import com.hakimen.wandrous.common.spell.SpellStatus;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class DrillSpellEffect
extends SpellEffect {
    ItemStack mineAs;

    public DrillSpellEffect(int cost, int radius) {
        this.setKind(8);
        this.setStatus(new SpellStatus().setManaDrain(cost).setRadius(radius));
    }

    @Override
    public void cast(SpellContext context) {
        context.mergeStatus(this.getStatus());
        int radius = (int)context.getStatus().getRadius();
        Vec3 location = context.getLocation();
        BlockPos pos = new BlockPos((int)Math.round(location.x), (int)Math.round(location.y), (int)Math.round(location.z));
        Level level = context.getLevel();
        Iterator positions = BlockPos.betweenClosed((BlockPos)pos.offset(-radius, -radius, -radius), (BlockPos)pos.offset(radius, radius, radius)).iterator();
        ArrayList stacksList = new ArrayList();
        while (positions.hasNext()) {
            BlockPos blockpos = (BlockPos)positions.next();
            if (!blockpos.closerToCenterThan((Position)location, (double)radius)) continue;
            BlockState state = level.getBlockState(blockpos);
            if (level.isClientSide || !state.is(BlockTags.MINEABLE_WITH_PICKAXE) && !state.is(BlockTags.MINEABLE_WITH_SHOVEL)) continue;
            List stackList = state.getDrops(new LootParams.Builder((ServerLevel)context.getLevel()).withParameter(LootContextParams.TOOL, (Object)this.getMineAs()).withParameter(LootContextParams.ORIGIN, (Object)pos.getCenter()));
            level.setBlockAndUpdate(blockpos, Blocks.AIR.defaultBlockState());
            stacksList.addAll(stackList);
        }
        stacksList.stream().reduce((i1, i2) -> {
            if (i1.getCount() + i2.getCount() <= i1.getMaxStackSize()) {
                i1.setCount(i1.getCount() + i2.getCount());
            }
            return i1;
        });
        for (ItemStack stack : stacksList) {
            ItemEntity entity = new ItemEntity(EntityType.ITEM, level);
            entity.setItem(stack);
            entity.setPos(location.x() + 0.5 + (double)((float)level.getRandom().nextInt(-1, 1) / 4.0f), location.y() + 0.5 + (double)((float)level.getRandom().nextInt(-1, 1) / 4.0f), location.z() + 0.5 + (double)((float)level.getRandom().nextInt(-1, 1) / 4.0f));
            level.addFreshEntity((Entity)entity);
        }
    }

    public ItemStack getMineAs() {
        return this.mineAs;
    }

    public DrillSpellEffect setMineAs(ItemStack mineAs) {
        this.mineAs = mineAs;
        return this;
    }
}

