/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.spell.effects.spells.static_projectiles;

import com.hakimen.wandrous.common.payloads.PositionalScreenShakePacket;
import com.hakimen.wandrous.common.spell.SpellContext;
import com.hakimen.wandrous.common.spell.SpellEffect;
import com.hakimen.wandrous.common.spell.SpellStatus;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class ExplosionSpellEffect
extends SpellEffect {
    public ExplosionSpellEffect(float strength) {
        this.setKind(8);
        this.setStatus(new SpellStatus().setDamage(strength).setManaDrain(20 * (int)strength).setCritChance(0.0f));
    }

    @Override
    public void cast(SpellContext context) {
        context.mergeStatus(this.getStatus());
        Level level = context.getLevel();
        Vec3 location = context.getLocation();
        PacketDistributor.sendToPlayersNear((ServerLevel)((ServerLevel)level), null, (double)location.x, (double)location.y, (double)location.z, (double)50.0, (CustomPacketPayload)new PositionalScreenShakePacket(context.getStatus().getDamage() / 8.0f, 20, 40, location.toVector3f(), 50.0f), (CustomPacketPayload[])new CustomPacketPayload[0]);
        level.explode(null, location.x, location.y, location.z, context.getStatus().getDamage(), Level.ExplosionInteraction.MOB);
    }
}

