/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.spell.effects.spells.projectiles;

import com.hakimen.wandrous.common.entity.projectiles.GlimmeringBoltProjectile;
import com.hakimen.wandrous.common.spell.SpellContext;
import com.hakimen.wandrous.common.spell.SpellStatus;
import com.hakimen.wandrous.common.spell.effects.spells.projectiles.ProjectileSpellEffect;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GlimmeringBoltSpellEffect
extends ProjectileSpellEffect {
    public GlimmeringBoltSpellEffect(int kind) {
        this.setKind(kind);
        this.setStatus(new SpellStatus().setDamage(2.0f).setManaDrain(20).setSpeed(1.5f).setSpread(0.2f).setLifeTime(50));
    }

    @Override
    public void cast(SpellContext context) {
        context.mergeStatus(this.getStatus());
        Level level = context.getLevel();
        Vec3 location = context.getLocation();
        GlimmeringBoltProjectile glimmeringBoltProjectile = new GlimmeringBoltProjectile(location.x, location.y, location.z, level, context);
        level.playSound(null, context.getCaster().getOnPos(), SoundEvents.ALLAY_ITEM_TAKEN, SoundSource.PLAYERS, 1.0f, 1.0f);
        GlimmeringBoltSpellEffect.shootProjectile((Projectile)glimmeringBoltProjectile, context);
        level.addFreshEntity((Entity)glimmeringBoltProjectile);
    }
}

