/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.spell.effects.modifiers.powerups;

import com.hakimen.wandrous.common.spell.SpellContext;
import com.hakimen.wandrous.common.spell.SpellEffect;
import com.hakimen.wandrous.common.spell.SpellStack;
import com.hakimen.wandrous.common.spell.SpellStatus;
import com.hakimen.wandrous.common.utils.data.Node;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FriendshipToPowerSpellEffect
extends SpellEffect {
    public FriendshipToPowerSpellEffect() {
        this.setKind(2);
        this.setStatus(new SpellStatus().setManaDrain(60).setRadius(8.0f));
    }

    @Override
    public void cast(SpellContext context) {
        context.mergeStatus(this.getStatus());
        LivingEntity actualCaster = (LivingEntity)context.getOriginalCaster();
        float radius = context.getStatus().getRadius();
        float owned = context.getLevel().getEntities((Entity)actualCaster, AABB.ofSize((Vec3)context.getLocation(), (double)radius, (double)radius, (double)radius)).stream().filter(entity -> entity instanceof OwnableEntity && ((OwnableEntity)entity).getOwner() == actualCaster).count();
        context.getStatus().setDamageMod(owned / 4.0f);
        for (Node<SpellStack> child : context.getNode().getChildren()) {
            child.getData().getEffect().cast(context.setNode(child));
        }
    }
}

