/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.spell.effects.modifiers.location;

import com.hakimen.wandrous.common.spell.SpellContext;
import com.hakimen.wandrous.common.spell.SpellEffect;
import com.hakimen.wandrous.common.spell.SpellStack;
import com.hakimen.wandrous.common.spell.SpellStatus;
import com.hakimen.wandrous.common.utils.data.Node;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TeleportCastEffect
extends SpellEffect {
    public TeleportCastEffect() {
        this.setKind(2);
        this.setStatus(new SpellStatus().setManaDrain(40));
    }

    @Override
    public void cast(SpellContext context) {
        Level level = context.getLevel();
        Vec3 location = context.getLocation();
        List allEntities = level.getEntities(context.getOriginalCaster(), AABB.ofSize((Vec3)location, (double)16.0, (double)16.0, (double)16.0), entity -> entity instanceof LivingEntity && !context.getHit().contains(entity));
        Entity closestEntity = null;
        for (Entity entity2 : allEntities) {
            if (closestEntity == null) {
                closestEntity = entity2;
                continue;
            }
            if (!(closestEntity.distanceToSqr(location) > entity2.distanceToSqr(location))) continue;
            closestEntity = entity2;
        }
        if (closestEntity != null) {
            context.setCastPositionModified(true);
            if (closestEntity instanceof LivingEntity) {
                LivingEntity entity3 = (LivingEntity)closestEntity;
                context.getHit().add(entity3);
            }
            context.setLocation(closestEntity.getPosition(0.0f));
        }
        for (Node node : context.getNode().getChildren()) {
            ((SpellStack)node.getData()).getEffect().cast(context.setNode(node));
        }
    }
}

