/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.spell.effects.modifiers.location;

import com.hakimen.wandrous.common.spell.SpellContext;
import com.hakimen.wandrous.common.spell.SpellEffect;
import com.hakimen.wandrous.common.spell.SpellStack;
import com.hakimen.wandrous.common.spell.SpellStatus;
import com.hakimen.wandrous.common.utils.data.Node;
import net.minecraft.world.phys.Vec3;

public class RelativeCastEffect
extends SpellEffect {
    public RelativeCastEffect() {
        this.setKind(2);
        this.setStatus(new SpellStatus().setManaDrain(40).setRadius(4.0f));
    }

    @Override
    public void cast(SpellContext context) {
        context.mergeStatus(this.getStatus());
        float castDistance = context.getStatus().getRadius();
        Vec3 location = context.getLocation();
        Vec3 lookAngle = context.getCaster().getLookAngle();
        Vec3 newLocation = new Vec3(location.x + (double)castDistance * lookAngle.x, location.y + (double)castDistance * lookAngle.y, location.z + (double)castDistance * lookAngle.z);
        context.setLocation(newLocation);
        context.setCastPositionModified(true);
        for (Node<SpellStack> child : context.getNode().getChildren()) {
            child.getData().getEffect().cast(context.setNode(child));
        }
    }
}

