/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.spell.effects.modifiers.charges;

import com.hakimen.wandrous.common.spell.SpellContext;
import com.hakimen.wandrous.common.spell.effects.modifiers.ProjectileHitEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class PoisonChargeHitEffect
extends ProjectileHitEffect {
    public PoisonChargeHitEffect(int cost) {
        super(cost);
    }

    @Override
    public void onHitEntity(SpellContext context, Entity hit) {
        context.mergeStatus(this.getStatus());
        if (hit instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)hit;
            entity.addEffect(new MobEffectInstance(MobEffects.POISON, 600, 1));
        }
    }

    @Override
    public void onHitBlock(SpellContext context, Level level, BlockPos pos, BlockState state) {
        context.mergeStatus(this.getStatus());
        AreaEffectCloud cloud = new AreaEffectCloud(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        cloud.addEffect(new MobEffectInstance(MobEffects.POISON, 600, 1));
        level.addFreshEntity((Entity)cloud);
    }
}

