/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.spell.effects.modifiers.charges;

import com.hakimen.wandrous.common.registers.EffectRegister;
import com.hakimen.wandrous.common.spell.SpellContext;
import com.hakimen.wandrous.common.spell.effects.modifiers.ProjectileHitEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class IgneousChargeHitEffect
extends ProjectileHitEffect {
    public IgneousChargeHitEffect(int cost) {
        super(cost);
    }

    @Override
    public void onHitEntity(SpellContext context, Entity hit) {
        context.mergeStatus(this.getStatus());
        if (hit instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)hit;
            entity.addEffect(new MobEffectInstance(EffectRegister.IGNITE, 600));
        }
    }

    @Override
    public void onHitBlock(SpellContext context, Level level, BlockPos pos, BlockState state) {
        context.mergeStatus(this.getStatus());
        int radius = (int)context.getStatus().getRadius();
        for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.offset(-radius, -radius, -radius), (BlockPos)pos.offset(radius, radius, radius))) {
            if (!blockpos.closerToCenterThan((Position)pos.getCenter(), (double)(radius - 1))) continue;
            BlockState blockstate = level.getBlockState(blockpos);
            BlockState aboveState = level.getBlockState(blockpos.above());
            if (blockstate.is(Blocks.AIR) || blockstate.is(Blocks.FIRE) && blockstate.is(Blocks.SOUL_FIRE) || !aboveState.is(Blocks.AIR)) continue;
            level.setBlockAndUpdate(blockpos.above(), Blocks.FIRE.defaultBlockState());
        }
    }
}

