/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.spell.effects.modifiers.charges;

import com.hakimen.wandrous.common.registers.EffectRegister;
import com.hakimen.wandrous.common.spell.SpellContext;
import com.hakimen.wandrous.common.spell.effects.modifiers.ProjectileHitEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FreezingChargeHitEffect
extends ProjectileHitEffect {
    public FreezingChargeHitEffect(int cost) {
        super(cost);
    }

    @Override
    public void onHitEntity(SpellContext context, Entity hit) {
        context.mergeStatus(this.getStatus());
        if (hit instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)hit;
            if (!context.getLevel().dimensionType().effectsLocation().equals((Object)BuiltinDimensionTypes.NETHER_EFFECTS)) {
                entity.addEffect(new MobEffectInstance(EffectRegister.FREEZING, 600));
            }
        }
    }

    @Override
    public void onHitBlock(SpellContext context, Level level, BlockPos pos, BlockState state) {
        context.mergeStatus(this.getStatus());
        int radius = (int)context.getStatus().getRadius();
        for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.offset(-radius, -radius, -radius), (BlockPos)pos.offset(radius, radius, radius))) {
            if (!blockpos.closerToCenterThan((Position)pos.getCenter(), (double)(radius - 1)) || level.dimensionType().effectsLocation().equals((Object)BuiltinDimensionTypes.NETHER_EFFECTS)) continue;
            BlockState blockstate = level.getBlockState(blockpos);
            BlockState aboveState = level.getBlockState(blockpos.above());
            if (blockstate.is(Blocks.WATER)) {
                level.setBlockAndUpdate(blockpos, Blocks.FROSTED_ICE.defaultBlockState());
            }
            if (!blockstate.is(Blocks.AIR) && Block.isShapeFullBlock((VoxelShape)blockstate.getShape((BlockGetter)level, pos)) && aboveState.is(Blocks.AIR)) {
                level.setBlockAndUpdate(blockpos.above(), Blocks.SNOW.defaultBlockState());
            }
            if (blockstate.is(Blocks.LAVA)) {
                if (blockstate.equals(Blocks.LAVA.defaultBlockState())) {
                    level.setBlockAndUpdate(blockpos, Blocks.OBSIDIAN.defaultBlockState());
                } else {
                    level.setBlockAndUpdate(blockpos, Blocks.COBBLESTONE.defaultBlockState());
                }
            }
            if (!blockstate.is(Blocks.MAGMA_BLOCK)) continue;
            level.setBlockAndUpdate(blockpos, Blocks.NETHERRACK.defaultBlockState());
        }
    }
}

