/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.spell.effects.modifiers;

import com.hakimen.wandrous.common.spell.SpellContext;
import com.hakimen.wandrous.common.spell.SpellStack;
import com.hakimen.wandrous.common.spell.SpellStatus;
import com.hakimen.wandrous.common.spell.effects.modifiers.MultiCastEffect;
import com.hakimen.wandrous.common.utils.data.Node;
import net.minecraft.world.phys.Vec3;

public class LineCastEffect
extends MultiCastEffect {
    public LineCastEffect(int count) {
        super(count);
        this.setKind(2);
        this.setStatus(new SpellStatus().setManaDrain(40).setRadius(2.0f));
    }

    @Override
    public void cast(SpellContext context) {
        context.mergeStatus(this.getStatus());
        float castDistance = context.getStatus().getRadius();
        Vec3 location = context.getLocation();
        for (Node<SpellStack> child : context.getNode().getChildren()) {
            Vec3 lookAngle = context.getCaster().getLookAngle();
            Vec3 newLocation = new Vec3(location.x + (double)(castDistance += context.getStatus().getRadius()) * lookAngle.x, location.y + (double)castDistance * lookAngle.y, location.z + (double)castDistance * lookAngle.z);
            context.setCastPositionModified(true);
            context.setCastPositionModified(true);
            context.setLocation(newLocation);
            location = newLocation;
            child.getData().getEffect().cast(context.setNode(child));
        }
    }
}

